/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.undo.impl.custom;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionProcessor;
import app.tuxguitar.editor.undo.TGCannotRedoException;
import app.tuxguitar.editor.undo.TGCannotUndoException;
import app.tuxguitar.editor.undo.impl.TGUndoableEditBase;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.util.TGContext;

public class TGUndoableAltRepeat
extends TGUndoableEditBase {
    private int doAction;
    private long position;
    private int undoRepeatAlternative;
    private int redoRepeatAlternative;

    private TGUndoableAltRepeat(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.changeAlternativeRepeat(actionContext, this.getMeasureHeaderAt(this.position), this.redoRepeatAlternative);
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.changeAlternativeRepeat(actionContext, this.getMeasureHeaderAt(this.position), this.undoRepeatAlternative);
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableAltRepeat startUndo(TGContext context, TGMeasureHeader header) {
        TGUndoableAltRepeat undoable = new TGUndoableAltRepeat(context);
        undoable.doAction = 1;
        undoable.position = header.getStart();
        undoable.undoRepeatAlternative = header.getRepeatAlternative();
        return undoable;
    }

    public TGUndoableAltRepeat endUndo(int redoRepeatAlternative) {
        this.redoRepeatAlternative = redoRepeatAlternative;
        return this;
    }

    public TGMeasureHeader getMeasureHeaderAt(Long start) {
        return this.getSongManager().getMeasureHeaderAt(this.getSong(), start.longValue());
    }

    public void changeAlternativeRepeat(TGActionContext context, TGMeasureHeader header, Integer repeatAlternative) {
        TGActionProcessor tgActionProcessor = this.createByPassUndoableAction("action.insert.close-alternative");
        tgActionProcessor.setAttribute("repeatAlternative", repeatAlternative);
        tgActionProcessor.setAttribute(TGDocumentContextAttributes.ATTRIBUTE_HEADER, header);
        this.processByPassUndoableAction(tgActionProcessor, context);
    }
}

