/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.action.note;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.song.models.TGVoice;
import app.tuxguitar.util.TGContext;

public class TGChangeNoteAction
extends TGActionBase {
    public static final String NAME = "action.note.general.change";

    public TGChangeNoteAction(TGContext context) {
        super(context, NAME);
    }

    @Override
    protected void processAction(TGActionContext context) {
        Long start = (Long)context.getAttribute("position");
        Integer fret = (Integer)context.getAttribute("fret");
        Integer velocity = (Integer)context.getAttribute("velocity");
        TGDuration duration = (TGDuration)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_DURATION);
        TGVoice voice = (TGVoice)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_VOICE);
        TGMeasure measure = (TGMeasure)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_MEASURE);
        TGBeat beat = (TGBeat)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_BEAT);
        TGString string = (TGString)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_STRING);
        TGTrack track = (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK);
        TGSongManager songManager = this.getSongManager(context);
        boolean freeEditionMode = songManager.isFreeEditionMode(measure);
        if (track != null && (track.isPercussion() || fret <= track.getMaxFret())) {
            TGNote note = songManager.getFactory().newNote();
            note.setValue(fret.intValue());
            note.setVelocity(velocity.intValue());
            note.setString(string.getNumber());
            if (beat != null && freeEditionMode) {
                songManager.getMeasureManager().addNoteWithoutControl(beat, note, duration.clone(songManager.getFactory()), voice.getIndex());
                context.setAttribute("success", (Object)Boolean.TRUE);
            } else if (measure != null && fret >= 0) {
                songManager.getMeasureManager().addNote(measure, start.longValue(), note, duration.clone(songManager.getFactory()), voice.getIndex());
                context.setAttribute("success", (Object)Boolean.TRUE);
            }
        }
    }
}

