/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.editor.action.measure;

import app.tuxguitar.action.TGActionContext;
import app.tuxguitar.document.TGDocumentContextAttributes;
import app.tuxguitar.editor.action.TGActionBase;
import app.tuxguitar.editor.clipboard.TGClipboard;
import app.tuxguitar.song.helpers.TGSongSegment;
import app.tuxguitar.song.helpers.TGSongSegmentHelper;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.util.TGContext;

public class TGCopyMeasureAction
extends TGActionBase {
    public static final String NAME = "action.measure.copy";
    public static final String ATTRIBUTE_ALL_TRACKS = "copyAllTracks";
    public static final String ATTRIBUTE_MEASURE_NUMBER_1 = "measureNumber1";
    public static final String ATTRIBUTE_MEASURE_NUMBER_2 = "measureNumber2";
    public static final String ATTRIBUTE_COPY_MARKERS = "copyMarkers";

    public TGCopyMeasureAction(TGContext context) {
        super(context, NAME);
    }

    @Override
    protected void processAction(TGActionContext context) {
        Integer m1 = (Integer)context.getAttribute(ATTRIBUTE_MEASURE_NUMBER_1);
        Integer m2 = (Integer)context.getAttribute(ATTRIBUTE_MEASURE_NUMBER_2);
        Boolean allTracks = (Boolean)context.getAttribute(ATTRIBUTE_ALL_TRACKS);
        if (m1 > 0 && m1 <= m2) {
            TGSong song = (TGSong)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
            TGSongSegmentHelper helper = new TGSongSegmentHelper(this.getSongManager(context));
            TGSongSegment segment = null;
            segment = Boolean.TRUE.equals(allTracks) ? helper.copyMeasures(song, m1.intValue(), m2.intValue()) : helper.copyMeasures(song, m1.intValue(), m2.intValue(), (TGTrack)context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_TRACK));
            if (!Boolean.TRUE.equals(context.getAttribute(ATTRIBUTE_COPY_MARKERS))) {
                for (TGMeasureHeader header : segment.getHeaders()) {
                    header.setMarker(null);
                }
            }
            TGClipboard.getInstance(this.getContext()).setData(segment);
        }
    }
}

