/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.gm.port;

import app.tuxguitar.gm.GMChannelRouter;
import app.tuxguitar.gm.port.GMChannel;
import app.tuxguitar.gm.port.GMOutputPort;
import app.tuxguitar.gm.port.GMSynthesizerRouter;
import app.tuxguitar.player.base.MidiChannel;
import app.tuxguitar.player.base.MidiPlayerException;
import app.tuxguitar.player.base.MidiSynthesizer;
import java.util.ArrayList;
import java.util.List;

public class GMSynthesizer
implements MidiSynthesizer {
    private List<GMChannel> channels;
    private GMOutputPort outputPort;
    private GMChannelRouter router;

    public GMSynthesizer(GMOutputPort midiOutputPort) {
        this.outputPort = midiOutputPort;
        this.channels = new ArrayList<GMChannel>();
        this.router = new GMSynthesizerRouter(this);
    }

    public void closeChannel(MidiChannel midiChannel) throws MidiPlayerException {
        if (this.isChannelOpen(midiChannel)) {
            this.router.removeRoute(((GMChannel)midiChannel).getRoute());
            this.channels.remove(midiChannel);
        }
    }

    public MidiChannel openChannel(int channelId) throws MidiPlayerException {
        MidiChannel channel = this.getChannel(channelId);
        if (channel == null) {
            channel = new GMChannel(channelId, this.router, this.outputPort.getReceiver());
            this.channels.add((GMChannel)channel);
        }
        return channel;
    }

    public MidiChannel getChannel(int channelId) throws MidiPlayerException {
        for (GMChannel channel : this.channels) {
            if (channel.getRoute().getChannelId() != channelId) continue;
            return channel;
        }
        return null;
    }

    public boolean isChannelOpen(MidiChannel midiChannel) throws MidiPlayerException {
        if (midiChannel instanceof GMChannel) {
            return this.getChannel(((GMChannel)midiChannel).getRoute().getChannelId()) != null;
        }
        return false;
    }

    public boolean isBusy() {
        return false;
    }

    public List<GMChannel> getChannels() {
        return this.channels;
    }

    public GMChannelRouter getRouter() {
        return this.router;
    }
}

