/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.util;

import app.tuxguitar.song.helpers.TGBeatRangeNoteIterator;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGNote;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

public class TGNoteRange {
    private List<TGNote> notes;
    private List<TGMeasure> measures;
    private List<TGBeat> beats;

    public TGNoteRange(List<TGNote> notes) {
        TreeSet<TGMeasure> measures = new TreeSet<TGMeasure>(Comparator.comparingLong(a -> a.getHeader().getNumber()));
        TreeSet<TGBeat> beats = new TreeSet<TGBeat>(Comparator.comparingLong(TGBeat::getStart));
        this.notes = notes;
        for (TGNote note : notes) {
            TGBeat beat = note.getVoice().getBeat();
            beats.add(beat);
            measures.add(beat.getMeasure());
        }
        this.measures = new ArrayList<TGMeasure>(measures);
        this.beats = new ArrayList<TGBeat>(beats);
    }

    public TGNoteRange(TGBeat start, TGBeat end, Collection<Integer> voices) {
        this(new TGBeatRangeNoteIterator(start, end, voices).toList());
    }

    public static TGNoteRange single(TGNote note) {
        return new TGNoteRange(Collections.singletonList(note));
    }

    public static TGNoteRange empty() {
        return new TGNoteRange(Collections.emptyList());
    }

    public List<TGNote> getNotes() {
        return this.notes;
    }

    public boolean isEmpty() {
        return this.notes.isEmpty();
    }

    public TGMeasure firstMeasure() {
        return this.measures.get(0);
    }

    public TGMeasure lastMeasure() {
        return this.measures.get(this.measures.size() - 1);
    }

    public List<TGMeasure> getMeasures() {
        return this.measures;
    }

    public List<TGBeat> getBeats() {
        return this.beats;
    }
}

