/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.util;

import app.tuxguitar.player.base.MidiInstrument;
import app.tuxguitar.player.base.MidiPercussionKey;
import app.tuxguitar.resource.TGResourceBundle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class TGMessagesManager {
    private static TGMessagesManager instance;
    private static final String INSTRUMENT_NAME_PREFIX = "midi.instrument-";
    private static final String PERCUSSION_NAME_PREFIX = "midi.percussion-key-";
    private TGResourceBundle resources;
    private List<MidiInstrument> instruments = null;
    private List<MidiPercussionKey> percussionKeys = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TGMessagesManager getInstance() {
        Class<TGMessagesManager> clazz = TGMessagesManager.class;
        synchronized (TGMessagesManager.class) {
            if (instance == null) {
                instance = new TGMessagesManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TGMessagesManager() {
    }

    public void setResources(TGResourceBundle bundle) {
        this.resources = bundle;
        this.instruments = new ArrayList<MidiInstrument>();
        int i = 0;
        String name = TGMessagesManager.getProperty(INSTRUMENT_NAME_PREFIX + String.valueOf(i));
        while (!name.equals(INSTRUMENT_NAME_PREFIX + String.valueOf(i))) {
            this.instruments.add(new MidiInstrument(name));
            name = TGMessagesManager.getProperty(INSTRUMENT_NAME_PREFIX + String.valueOf(++i));
        }
        this.percussionKeys = new ArrayList<MidiPercussionKey>();
        i = 0;
        name = TGMessagesManager.getProperty(PERCUSSION_NAME_PREFIX + String.valueOf(i));
        while (i < 100 && name.equals(PERCUSSION_NAME_PREFIX + String.valueOf(i))) {
            name = TGMessagesManager.getProperty(PERCUSSION_NAME_PREFIX + String.valueOf(++i));
        }
        while (!name.equals(PERCUSSION_NAME_PREFIX + String.valueOf(i))) {
            this.percussionKeys.add(new MidiPercussionKey(i, name));
            name = TGMessagesManager.getProperty(PERCUSSION_NAME_PREFIX + String.valueOf(++i));
        }
    }

    public static String getProperty(String key) {
        try {
            String property = TGMessagesManager.getInstance().resources.getString(key);
            if (property == null) {
                if (!key.startsWith(INSTRUMENT_NAME_PREFIX) && !key.startsWith(PERCUSSION_NAME_PREFIX)) {
                    System.err.println("Message " + key + " not found");
                }
                return key;
            }
            return property;
        }
        catch (Throwable throwable) {
            return key;
        }
    }

    public static String getProperty(String key, Object[] arguments) {
        String property = TGMessagesManager.getProperty(key);
        if (arguments == null || arguments.length == 0) {
            return property;
        }
        String newProperty = new String(property);
        try {
            for (int i = 0; i < arguments.length; ++i) {
                newProperty = newProperty.replace("{" + String.valueOf(i) + "}", String.valueOf(arguments[i]));
            }
        }
        catch (Throwable e) {
            return property;
        }
        return newProperty;
    }

    public static MidiInstrument getMidiInstrument(int index) {
        if (TGMessagesManager.getInstance().instruments == null) {
            return null;
        }
        int len = TGMessagesManager.getInstance().instruments.size();
        if (index < 0 || index >= len) {
            return null;
        }
        return TGMessagesManager.getInstance().instruments.get(index);
    }

    public static int getMidiInstrumentsNumber() {
        if (TGMessagesManager.getInstance().instruments == null) {
            return 0;
        }
        return TGMessagesManager.getInstance().instruments.size();
    }

    public static MidiInstrument[] getInstruments() {
        if (TGMessagesManager.getInstance().instruments == null) {
            return null;
        }
        return TGMessagesManager.getInstance().instruments.toArray(new MidiInstrument[0]);
    }

    public static MidiPercussionKey[] getMidiPercussionKeys() {
        return TGMessagesManager.getInstance().percussionKeys.toArray(new MidiPercussionKey[0]);
    }

    public String getLanguage() {
        if (this.resources != null) {
            Locale locale = this.resources.getLocale();
            boolean language = locale.getLanguage() != null && locale.getLanguage().length() > 0;
            boolean country = locale.getCountry() != null && locale.getCountry().length() > 0;
            boolean variant = locale.getVariant() != null && locale.getVariant().length() > 0;
            Object localeId = new String();
            if (language) {
                localeId = (String)localeId + locale.getLanguage();
            }
            if (country) {
                localeId = (String)localeId + "_" + locale.getCountry();
            }
            if (variant) {
                localeId = (String)localeId + "_" + (String)(country ? locale.getVariant() : "_" + locale.getVariant());
            }
            return localeId;
        }
        return null;
    }

    public Locale getLocale() {
        if (this.resources == null) {
            return null;
        }
        return this.resources.getLocale();
    }
}

