/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.song.models.effects;

import app.tuxguitar.song.factory.TGFactory;
import java.util.ArrayList;
import java.util.List;

public abstract class TGEffectBend {
    public static final int SEMITONE_LENGTH = 1;
    public static final int MAX_POSITION_LENGTH = 12;
    public static final int MAX_VALUE_LENGTH = 12;
    private List<BendPoint> points;
    private List<Integer> movements = new ArrayList<Integer>();

    public TGEffectBend() {
        this.points = new ArrayList<BendPoint>();
    }

    public void addPoint(int position, int value) {
        this.points.add(new BendPoint(position, value));
        this.updateMovements();
    }

    public List<BendPoint> getPoints() {
        return this.points;
    }

    public List<Integer> getMovements() {
        return this.movements;
    }

    public TGEffectBend clone(TGFactory factory) {
        TGEffectBend effect = factory.newEffectBend();
        for (BendPoint point : this.getPoints()) {
            effect.addPoint(point.getPosition(), point.getValue());
        }
        return effect;
    }

    private void updateMovements() {
        this.movements.clear();
        if (this.points.size() < 2) {
            return;
        }
        int start = this.points.get(0).getValue();
        int current = this.points.get(1).getValue();
        for (int i = 2; i < this.points.size(); ++i) {
            int next = this.points.get(i).getValue();
            if ((next - current) * (current - start) < 0) {
                if (current - start > 0) {
                    this.movements.add(current);
                } else {
                    this.movements.add(-start);
                }
                start = current;
            }
            current = next;
        }
        if (current - start > 0) {
            this.movements.add(current);
        } else if (current - start < 0) {
            this.movements.add(-start);
        }
    }

    public class BendPoint {
        private int position;
        private int value;

        public BendPoint(int position, int value) {
            this.position = position;
            this.value = value;
        }

        public int getPosition() {
            return this.position;
        }

        public int getValue() {
            return this.value;
        }

        public long getTime(long duration) {
            return duration * (long)this.getPosition() / 12L;
        }

        public Object clone() {
            return new BendPoint(this.getPosition(), this.getValue());
        }
    }
}

