/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.song.models;

import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGDivisionType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TGDuration
implements Comparable<TGDuration> {
    public static final long QUARTER_TIME = 960L;
    public static long WHOLE_PRECISE_DURATION = 64L;
    public static final int WHOLE = 1;
    public static final int HALF = 2;
    public static final int QUARTER = 4;
    public static final int EIGHTH = 8;
    public static final int SIXTEENTH = 16;
    public static final int THIRTY_SECOND = 32;
    public static final int SIXTY_FOURTH = 64;
    public static final int SHORTEST = 64;
    private int value = 4;
    private boolean dotted = false;
    private boolean doubleDotted = false;
    private TGDivisionType divisionType;
    private static List<TGDivisionType> divisionTypes = new ArrayList<TGDivisionType>();
    private static final Map<Long, TGDuration> durationMap;

    public static long toTime(long preciseTime) {
        return 3840L * preciseTime / WHOLE_PRECISE_DURATION;
    }

    public static long toPreciseTime(long ticks) {
        return ticks * WHOLE_PRECISE_DURATION / 3840L;
    }

    public static Long getStartingPoint() {
        return 960L;
    }

    public static Long getPreciseStartingPoint() {
        return TGDuration.toPreciseTime(TGDuration.getStartingPoint());
    }

    public static List<TGDuration> splitPreciseDuration(long timeToSplit, long maxTime, TGDuration preferredDuration, TGFactory factory) {
        if (preferredDuration != null && preferredDuration.getPreciseTime() <= maxTime) {
            long preferredTime = preferredDuration.getPreciseTime();
            Long remainingTime = timeToSplit;
            ArrayList<TGDuration> list = new ArrayList<TGDuration>();
            while (remainingTime >= preferredTime) {
                list.add(preferredDuration.clone(factory));
                remainingTime = remainingTime - preferredTime;
            }
            List<TGDuration> remainingList = TGDuration.splitPreciseDuration(remainingTime, maxTime, factory);
            if (remainingList != null) {
                list.addAll(remainingList);
                return list;
            }
        }
        return TGDuration.splitPreciseDuration(timeToSplit, maxTime, factory);
    }

    public static List<TGDuration> splitPreciseDuration(long timeToSplit, long max, TGFactory factory) {
        long maxBase;
        long D = timeToSplit;
        ArrayList<TGDuration> list = new ArrayList<TGDuration>();
        for (maxBase = WHOLE_PRECISE_DURATION; max < maxBase; maxBase /= 2L) {
        }
        block6: for (TGDivisionType dt : divisionTypes) {
            if (dt.getEnters() != 1 && D % (long)dt.getEnters() == 0L) continue;
            boolean foundDurationWithTimeDivision = false;
            for (int subDivision = 1; subDivision <= 4 && !foundDurationWithTimeDivision; subDivision *= 2) {
                long toSubtract;
                long base = WHOLE_PRECISE_DURATION * (long)dt.getTimes() / (long)(dt.getEnters() * 64);
                if ((base /= (long)subDivision) > maxBase) continue block6;
                if (dt.getEnters() == 1) {
                    toSubtract = D;
                } else {
                    for (toSubtract = base; (D - toSubtract) % (long)dt.getEnters() != 0L && toSubtract <= D; toSubtract += base) {
                    }
                }
                if (toSubtract % base != 0L || toSubtract > D) continue;
                long nBase = toSubtract / base;
                long n = 1L;
                while (nBase % 2L == 0L && n * 2L * base <= max) {
                    n *= 2L;
                    nBase /= 2L;
                }
                boolean ok = false;
                boolean dotted = false;
                boolean doubleDotted = false;
                switch (subDivision) {
                    case 1: {
                        ok = true;
                        break;
                    }
                    case 2: {
                        ok = nBase % 3L == 0L;
                        dotted = true;
                        nBase /= 3L;
                        base *= 2L;
                        break;
                    }
                    case 4: {
                        ok = nBase % 7L == 0L;
                        doubleDotted = true;
                        nBase /= 7L;
                        base *= 4L;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (!ok) continue;
                int i = 0;
                while ((long)i < nBase) {
                    TGDuration duration = factory.newDuration();
                    duration.setPreciseValue(n * base);
                    duration.setDotted(dotted);
                    duration.setDoubleDotted(doubleDotted);
                    list.add(duration);
                    ++i;
                }
                D -= toSubtract;
                foundDurationWithTimeDivision = true;
            }
        }
        if (D != 0L) {
            return null;
        }
        return list;
    }

    private static long gcd(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return TGDuration.gcd(b, a % b);
    }

    private static long lcm(long a, long b) {
        return a * b / TGDuration.gcd(a, b);
    }

    public TGDuration(TGFactory factory) {
        this.divisionType = factory.newDivisionType();
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void setPreciseValue(Long preciseValue) {
        TGDuration duration = durationMap.get(preciseValue);
        if (duration == null) {
            throw new IllegalArgumentException("invalid duration " + String.valueOf(preciseValue) + " /whole=" + String.valueOf(WHOLE_PRECISE_DURATION));
        }
        this.copyFrom(duration);
    }

    public boolean isDotted() {
        return this.dotted;
    }

    public void setDotted(boolean dotted) {
        this.dotted = dotted;
    }

    public boolean isDoubleDotted() {
        return this.doubleDotted;
    }

    public void setDoubleDotted(boolean doubleDotted) {
        this.doubleDotted = doubleDotted;
    }

    public TGDivisionType getDivision() {
        return this.divisionType;
    }

    public long getTime() {
        long time = (long)(960.0f * (4.0f / (float)this.value));
        if (this.dotted) {
            time += time / 2L;
        } else if (this.doubleDotted) {
            time += time / 4L * 3L;
        }
        return this.divisionType.convertTime(time);
    }

    public static TGDuration getShortestDuration(TGFactory factory) {
        TGDuration minimum = factory.newDuration();
        minimum.setValue(64);
        minimum.setDotted(false);
        minimum.setDoubleDotted(false);
        minimum.getDivision().setEnters(7);
        minimum.getDivision().setTimes(4);
        return minimum;
    }

    public static TGDuration fromTime(TGFactory factory, long time) {
        TGDuration duration = TGDuration.getShortestDuration(factory);
        return TGDuration.fromTime(factory, time, duration);
    }

    public static TGDuration fromTime(TGFactory factory, long time, TGDuration minDuration) {
        int threshold = 0;
        long quaterTimeConstant = 960L;
        if (quaterTimeConstant == 960L) {
            if (time < 60L) {
                threshold = 2;
            } else if (time == 95L) {
                threshold = 3;
            } else if (time == 138L) {
                threshold = 1;
            } else if (time == 177L) {
                threshold = 3;
            } else if (time == 748L) {
                threshold = 2;
            } else if (time == 854L) {
                threshold = 1;
            }
        }
        return TGDuration.fromTime(factory, time, minDuration, (short)threshold);
    }

    public static TGDuration fromTime(TGFactory factory, long time, TGDuration minimum, short threshold) {
        TGDuration durationFound = null;
        for (int i = 0; i <= threshold; ++i) {
            durationFound = durationMap.get(time - (long)i);
            if (durationFound == null) continue;
            return durationFound.clone(factory);
        }
        durationFound = factory.newDuration();
        for (int v = 1; v <= 64; v *= 2) {
            durationFound.setValue(v);
            if (time < durationFound.getTime()) continue;
            return durationFound.clone(factory);
        }
        return minimum.clone(factory);
    }

    public int getIndex() {
        int index = 0;
        int value = this.value;
        while ((value >>= 1) > 0) {
            ++index;
        }
        return index;
    }

    public long getPreciseTime() {
        long preciseDuration = WHOLE_PRECISE_DURATION / (long)this.value;
        if (this.dotted) {
            preciseDuration = preciseDuration * 3L / 2L;
        } else if (this.doubleDotted) {
            preciseDuration = preciseDuration * 7L / 4L;
        }
        preciseDuration = preciseDuration * (long)this.divisionType.getTimes() / (long)this.divisionType.getEnters();
        return preciseDuration;
    }

    public boolean isEqual(TGDuration d) {
        return this.getValue() == d.getValue() && this.isDotted() == d.isDotted() && this.isDoubleDotted() == d.isDoubleDotted() && this.getDivision().isEqual(d.getDivision());
    }

    public TGDuration clone(TGFactory factory) {
        TGDuration tgDuration = factory.newDuration();
        tgDuration.copyFrom(this);
        return tgDuration;
    }

    public void copyFrom(TGDuration duration) {
        this.setValue(duration.getValue());
        this.setDotted(duration.isDotted());
        this.setDoubleDotted(duration.isDoubleDotted());
        this.getDivision().copyFrom(duration.getDivision());
    }

    @Override
    public int compareTo(TGDuration duration) {
        if (duration == null) {
            return 1;
        }
        if (this.getPreciseTime() >= 0L && duration.getPreciseTime() >= 0L) {
            return Long.valueOf(this.getPreciseTime()).compareTo(duration.getPreciseTime());
        }
        return Long.valueOf(this.getTime()).compareTo(duration.getTime());
    }

    private static Map<Long, TGDuration> createDurationMap() {
        TGFactory factory = new TGFactory();
        HashMap<Long, TGDuration> durationHashMap = new HashMap<Long, TGDuration>();
        for (TGDivisionType tmpDivisionType : TGDivisionType.DIVISION_TYPES) {
            for (int i = 0; i < 3; ++i) {
                for (int v = 1; v <= 64; v *= 2) {
                    TGDuration tmpDuration = factory.newDuration();
                    if (i == 1) {
                        tmpDuration.setDotted(true);
                        tmpDuration.setDoubleDotted(false);
                    } else if (i == 2) {
                        tmpDuration.setDotted(false);
                        tmpDuration.setDoubleDotted(true);
                    } else {
                        tmpDuration.setDotted(false);
                        tmpDuration.setDoubleDotted(false);
                    }
                    tmpDuration.setValue(v);
                    tmpDuration.getDivision().setEnters(tmpDivisionType.getEnters());
                    tmpDuration.getDivision().setTimes(tmpDivisionType.getTimes());
                    TGDuration entry = tmpDuration;
                    long key = entry.getPreciseTime();
                    if (durationHashMap.containsKey(key)) continue;
                    durationHashMap.put(key, entry);
                }
            }
        }
        return durationHashMap;
    }

    static {
        for (TGDivisionType dt : TGDivisionType.DIVISION_TYPES) {
            WHOLE_PRECISE_DURATION = TGDuration.lcm(WHOLE_PRECISE_DURATION, dt.getEnters());
            if (TGDuration.gcd(dt.getEnters(), dt.getTimes()) != 1L) continue;
            divisionTypes.add(dt);
        }
        WHOLE_PRECISE_DURATION *= 4L;
        Collections.sort(divisionTypes, (dt1, dt2) -> Integer.valueOf(dt2.getEnters()).compareTo(dt1.getEnters()));
        durationMap = TGDuration.createDurationMap();
    }
}

