/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.resource;

import app.tuxguitar.resource.TGResourceManager;
import app.tuxguitar.util.TGContext;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class TGResourceBundle {
    private Locale locale;
    private Properties properties;

    public TGResourceBundle(Locale locale, Properties properties) {
        this.locale = locale;
        this.properties = properties;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getString(String key) {
        return this.properties.getProperty(key);
    }

    public static TGResourceBundle getBundle(TGContext context, String baseName, Locale locale) {
        Properties properties = new Properties();
        Object bundleName = baseName.replace('.', '/');
        String bundleExtension = ".properties";
        TGResourceBundle.loadResources(context, (String)bundleName + bundleExtension, properties);
        bundleName = (String)bundleName + "_";
        if (locale.getLanguage() != null && locale.getLanguage().length() > 0) {
            bundleName = (String)bundleName + locale.getLanguage();
            TGResourceBundle.loadResources(context, (String)bundleName + bundleExtension, properties);
        }
        bundleName = (String)bundleName + "_";
        if (locale.getCountry() != null && locale.getCountry().length() > 0) {
            bundleName = (String)bundleName + locale.getCountry();
            TGResourceBundle.loadResources(context, (String)bundleName + bundleExtension, properties);
        }
        bundleName = (String)bundleName + "_";
        if (locale.getVariant() != null && locale.getVariant().length() > 0) {
            bundleName = (String)bundleName + locale.getVariant();
            TGResourceBundle.loadResources(context, (String)bundleName + bundleExtension, properties);
        }
        return new TGResourceBundle(locale, properties);
    }

    private static void loadResources(TGContext context, String name, Properties p) {
        try {
            Enumeration<URL> enumeration = TGResourceManager.getInstance(context).getResources(name);
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                Properties properties = new Properties();
                properties.load(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
                p.putAll((Map<?, ?>)properties);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

