/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.tg;

import app.tuxguitar.io.base.TGFileFormat;
import app.tuxguitar.io.base.TGFileFormatException;
import app.tuxguitar.io.base.TGSongReader;
import app.tuxguitar.io.base.TGSongReaderHandle;
import app.tuxguitar.io.tg.TGStream;
import app.tuxguitar.song.factory.TGFactory;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGChannel;
import app.tuxguitar.song.models.TGChannelParameter;
import app.tuxguitar.song.models.TGChord;
import app.tuxguitar.song.models.TGDuration;
import app.tuxguitar.song.models.TGLyric;
import app.tuxguitar.song.models.TGMarker;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGMeasureHeader;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGNoteEffect;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGText;
import app.tuxguitar.song.models.TGTrack;
import app.tuxguitar.song.models.TGVoice;
import app.tuxguitar.song.models.effects.TGEffectBend;
import app.tuxguitar.song.models.effects.TGEffectGrace;
import app.tuxguitar.song.models.effects.TGEffectHarmonic;
import app.tuxguitar.song.models.effects.TGEffectTremoloBar;
import app.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import app.tuxguitar.song.models.effects.TGEffectTrill;
import app.tuxguitar.util.TGMessagesManager;
import app.tuxguitar.util.TGVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TGSongReaderImpl
extends TGStream
implements TGSongReader {
    private TGFactory factory;

    @Override
    public TGFileFormat getFileFormat() {
        return TG_FORMAT;
    }

    @Override
    public void read(TGSongReaderHandle handle) throws TGFileFormatException {
        try {
            InputStream[] versionAndContent = this.getDecompressedVersionAndContent(handle.getInputStream());
            TGVersion version = this.getFileFormatVersion(versionAndContent[0]);
            if (version.getMajor() < FILE_FORMAT_TGVERSION.getMajor()) {
                throw new TGFileFormatException();
            }
            if (version.getMajor() > FILE_FORMAT_TGVERSION.getMajor()) {
                throw new TGFileFormatException(TGMessagesManager.getProperty("error.new-major-version"));
            }
            if (version.getMinor() > FILE_FORMAT_TGVERSION.getMinor()) {
                handle.setNewerFileFormatDetected(true);
            }
            this.readContent(handle, versionAndContent[1]);
        }
        catch (TGFileFormatException | IOException e) {
            throw new TGFileFormatException(e);
        }
    }

    public void readContent(TGSongReaderHandle handle, InputStream inputStream) throws TGFileFormatException {
        try {
            this.factory = handle.getFactory();
            TGSong song = this.factory.newSong();
            Document xmlDocument = this.getDocument(inputStream);
            Node root = this.getChildNode(xmlDocument, "TuxGuitarFile");
            Node nodeSong = this.getChildNode(root, "TGSong");
            this.readSong(song, nodeSong);
            inputStream.close();
            handle.setSong(song);
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private void readSong(TGSong song, Node nodeSong) {
        Node nodeElement = nodeSong.getFirstChild();
        song.setName(this.readSibling(nodeElement, "name"));
        song.setArtist(this.readSibling(nodeElement, "artist"));
        song.setAlbum(this.readSibling(nodeElement, "album"));
        song.setAuthor(this.readSibling(nodeElement, "author"));
        song.setDate(this.readSibling(nodeElement, "date"));
        song.setCopyright(this.readSibling(nodeElement, "copyright"));
        song.setWriter(this.readSibling(nodeElement, "writer"));
        song.setTranscriber(this.readSibling(nodeElement, "transcriber"));
        song.setComments(this.readSibling(nodeElement, "comments"));
        this.readChannels(song, nodeSong);
        this.readMeasureHeaders(song, nodeSong);
        this.readTracks(song, nodeSong);
    }

    private void readChannels(TGSong song, Node nodeSong) {
        Node nodeChannel = this.getChildNode(nodeSong, "TGChannel");
        while (nodeChannel != null) {
            Node nodeElement = nodeChannel.getFirstChild();
            TGChannel channel = this.factory.newChannel();
            channel.setChannelId(this.readSiblingInt(nodeElement, "id"));
            channel.setBank(this.readSiblingShort(nodeElement, "bank"));
            channel.setProgram(this.readSiblingShort(nodeElement, "program"));
            channel.setVolume(this.readSiblingShort(nodeElement, "volume"));
            channel.setBalance(this.readSiblingShort(nodeElement, "balance"));
            channel.setChorus(this.readSiblingShort(nodeElement, "chorus"));
            channel.setReverb(this.readSiblingShort(nodeElement, "reverb"));
            channel.setPhaser(this.readSiblingShort(nodeElement, "phaser"));
            channel.setTremolo(this.readSiblingShort(nodeElement, "tremolo"));
            channel.setName(this.readSibling(nodeElement, "name"));
            this.readChannelParameters(nodeChannel, channel);
            song.addChannel(channel);
            nodeChannel = this.getSiblingNode(nodeChannel.getNextSibling(), "TGChannel");
        }
    }

    private void readChannelParameters(Node nodeChannel, TGChannel channel) {
        Node nodeParameter = this.getChildNode(nodeChannel, "TGChannelParameter");
        while (nodeParameter != null) {
            TGChannelParameter parameter = this.factory.newChannelParameter();
            parameter.setKey(this.readAttribute(nodeParameter, "key"));
            parameter.setValue(this.readAttribute(nodeParameter, "value"));
            channel.addParameter(parameter);
            nodeParameter = this.getSiblingNode(nodeParameter.getNextSibling(), "TGChannelParameter");
        }
    }

    private void readMeasureHeaders(TGSong song, Node nodeSong) {
        Node nodeMeasureHeader = this.getChildNode(nodeSong, "TGMeasureHeader");
        int timeSignatureNumerator = 4;
        int timeSignatureDenominator = 4;
        int tempoValue = 120;
        int tempoBase = 4;
        boolean tempoDotted = false;
        int number = 1;
        long headerStart = 960L;
        while (nodeMeasureHeader != null) {
            TGMeasureHeader header = this.factory.newHeader();
            header.setNumber(number);
            header.setStart(headerStart);
            Node node = this.getChildNode(nodeMeasureHeader, "timeSignature");
            if (node != null) {
                timeSignatureNumerator = this.readAttributeInt(node, "numerator");
                timeSignatureDenominator = this.readAttributeInt(node, "denominator");
            }
            header.getTimeSignature().setNumerator(timeSignatureNumerator);
            header.getTimeSignature().getDenominator().setValue(timeSignatureDenominator);
            node = this.getChildNode(nodeMeasureHeader, "tempo");
            if (node != null) {
                Node nodeDotted;
                tempoValue = this.readInt(node);
                Node nodeBase = node.getAttributes().getNamedItem("base");
                if (nodeBase != null) {
                    tempoBase = this.readInt(nodeBase);
                }
                if ((nodeDotted = node.getAttributes().getNamedItem("dotted")) != null) {
                    tempoDotted = nodeDotted.getTextContent().equals("true");
                }
            }
            header.getTempo().setValueBase(tempoValue, tempoBase, tempoDotted);
            header.setRepeatOpen(this.getChildNode(nodeMeasureHeader, "repeatOpen") != null);
            node = this.getChildNode(nodeMeasureHeader, "repeatClose");
            if (node != null) {
                header.setRepeatClose(this.readInt(node));
            }
            int repeatAlternative = 0;
            node = this.getChildNode(nodeMeasureHeader, "repeatAlternative");
            if (node != null) {
                node = this.getChildNode(node, "alternative");
                while (node != null) {
                    repeatAlternative = (byte)((double)repeatAlternative + Math.pow(2.0, this.readInt(node) - 1));
                    node = this.getSiblingNode(node.getNextSibling(), "alternative");
                }
                header.setRepeatAlternative(repeatAlternative);
            }
            if ((node = this.getChildNode(nodeMeasureHeader, "marker")) != null) {
                TGMarker marker = this.factory.newMarker();
                marker.setMeasure(number);
                marker.setTitle(node.getTextContent());
                marker.getColor().setR(this.readAttributeInt(node, "R"));
                marker.getColor().setG(this.readAttributeInt(node, "G"));
                marker.getColor().setB(this.readAttributeInt(node, "B"));
                header.setMarker(marker);
            }
            if ((node = this.getChildNode(nodeMeasureHeader, "tripletFeel")) != null) {
                header.setTripletFeel((Integer)this.tripletsReadMap.get(node.getTextContent()));
            }
            if (this.getChildNode(nodeMeasureHeader, "lineBreak") != null) {
                header.setLineBreak(true);
            }
            song.addMeasureHeader(header);
            headerStart += header.getLength();
            ++number;
            nodeMeasureHeader = this.getSiblingNode(nodeMeasureHeader.getNextSibling(), "TGMeasureHeader");
        }
    }

    private void readTracks(TGSong song, Node nodeSong) {
        Node nodeTrack = this.getChildNode(nodeSong, "TGTrack");
        int number = 1;
        while (nodeTrack != null) {
            TGTrack track = this.factory.newTrack();
            track.setNumber(number);
            track.setSong(song);
            Node nodeMaxFret = nodeTrack.getAttributes().getNamedItem("maxFret");
            if (nodeMaxFret != null) {
                track.setMaxFret(this.readInt(nodeMaxFret));
            }
            Node nodeElement = this.getChildNode(nodeTrack, "name");
            track.setName(nodeElement.getTextContent());
            Node node = this.getSiblingNode(nodeElement, "soloMute");
            if (node != null) {
                track.setSolo("solo".equals(node.getTextContent()));
                track.setMute("mute".equals(node.getTextContent()));
            }
            track.setChannelId(this.readSiblingInt(nodeElement, "channelId"));
            node = this.getSiblingNode(nodeElement, "offset");
            if (node != null) {
                track.setOffset(this.readInt(node));
            }
            node = this.getSiblingNode(nodeElement, "color");
            track.getColor().setR(this.readAttributeInt(node, "R"));
            track.getColor().setG(this.readAttributeInt(node, "G"));
            track.getColor().setB(this.readAttributeInt(node, "B"));
            this.readStrings(track, this.getChildNode(nodeTrack, "TGString"));
            this.readLyrics(track, this.getChildNode(nodeTrack, "TGLyric"));
            this.readMeasures(track, nodeTrack);
            song.addTrack(track);
            ++number;
            nodeTrack = this.getSiblingNode(nodeTrack.getNextSibling(), "TGTrack");
        }
    }

    private void readLyrics(TGTrack track, Node nodeLyrics) {
        TGLyric lyrics = this.factory.newLyric();
        if (nodeLyrics != null) {
            lyrics.setLyrics(nodeLyrics.getTextContent());
            lyrics.setFrom(this.readAttributeInt(nodeLyrics, "from"));
            track.setLyrics(lyrics);
        }
    }

    private void readStrings(TGTrack track, Node nodeString) {
        ArrayList<TGString> list = new ArrayList<TGString>();
        int number = 1;
        while (nodeString != null) {
            TGString string = this.factory.newString();
            string.setNumber(number);
            string.setValue(this.readInt(nodeString));
            list.add(string);
            ++number;
            nodeString = this.getSiblingNode(nodeString.getNextSibling(), "TGString");
        }
        track.setStrings(list);
    }

    private void readMeasures(TGTrack track, Node nodeTrack) {
        boolean isFirstMeasure = true;
        Node nodeMeasure = this.getChildNode(nodeTrack, "TGMeasure");
        int index = 1;
        int clef = 1;
        int keySignature = 0;
        while (nodeMeasure != null) {
            TGMeasure measure = this.factory.newMeasure(track.getSong().getMeasureHeader(index - 1));
            Node node = this.getChildNode(nodeMeasure, "clef");
            if (node != null) {
                clef = (Integer)this.mapReadClefs.get(node.getTextContent());
            }
            measure.setClef(clef);
            node = this.getChildNode(nodeMeasure, "keySignature");
            if (node != null) {
                keySignature = this.readInt(node);
            }
            measure.setKeySignature(keySignature);
            this.readBeats(measure, nodeMeasure, isFirstMeasure);
            isFirstMeasure = false;
            track.addMeasure(measure);
            ++index;
            nodeMeasure = this.getSiblingNode(nodeMeasure.getNextSibling(), "TGMeasure");
        }
        if (index - 1 != track.getSong().countMeasureHeaders()) {
            System.out.printf("%d != %d\n", index, track.getSong().countMeasureHeaders());
            throw new TGFileFormatException("unexpected number of measures");
        }
    }

    private void readBeats(TGMeasure measure, Node nodeMeasure, boolean isFirst) {
        boolean isFirstBeat = isFirst;
        Node nodeBeat = this.getChildNode(nodeMeasure, "TGBeat");
        while (nodeBeat != null) {
            TGBeat beat = this.factory.newBeat();
            long preciseStart = this.readLong(this.getChildNode(nodeBeat, "preciseStart"));
            if (isFirstBeat && preciseStart != TGDuration.getPreciseStartingPoint()) {
                throw new TGFileFormatException();
            }
            isFirstBeat = false;
            beat.setPreciseStart(preciseStart);
            Node node = this.getChildNode(nodeBeat, "stroke");
            if (node != null) {
                beat.getStroke().setDirection((Integer)this.mapReadStroke.get(this.readAttribute(node, "direction")));
                beat.getStroke().setValue(this.readAttributeInt(node, "value"));
            }
            if ((node = this.getChildNode(nodeBeat, "pickStroke")) != null) {
                beat.getPickStroke().setDirection((Integer)this.mapReadPickStroke.get(node.getTextContent()));
            }
            if ((node = this.getChildNode(nodeBeat, "chord")) != null) {
                beat.setChord(this.readChord(node));
            }
            if ((node = this.getChildNode(nodeBeat, "text")) != null) {
                TGText text = this.factory.newText();
                text.setValue(node.getTextContent());
                beat.setText(text);
            }
            measure.addBeat(beat);
            Node nodeVoice = this.getChildNode(nodeBeat, "voice");
            this.readVoices(beat, nodeVoice);
            nodeBeat = this.getSiblingNode(nodeBeat.getNextSibling(), "TGBeat");
        }
    }

    private TGChord readChord(Node nodeChord) {
        ArrayList<Integer> fretValues = new ArrayList<Integer>();
        Node nodeString = this.getChildNode(nodeChord, "string");
        while (nodeString != null) {
            fretValues.add("".equals(nodeString.getTextContent()) ? -1 : this.readInt(nodeString));
            nodeString = this.getSiblingNode(nodeString.getNextSibling(), "string");
        }
        TGChord chord = this.factory.newChord(fretValues.size());
        chord.setName(this.getChildNode(nodeChord, "name").getTextContent());
        chord.setFirstFret(this.readInt(this.getChildNode(nodeChord, "firstFret")));
        for (int i = 0; i < fretValues.size(); ++i) {
            chord.addFretValue(i, (Integer)fretValues.get(i));
        }
        return chord;
    }

    private void readVoices(TGBeat beat, Node nodeVoice) {
        int index = 0;
        while (nodeVoice != null) {
            Node nodeDivisionType;
            TGVoice voice = beat.getVoice(index);
            Node nodeDirection = nodeVoice.getAttributes().getNamedItem("direction");
            if (nodeDirection != null) {
                voice.setDirection((Integer)this.mapReadDirection.get(nodeDirection.getTextContent()));
            }
            Node nodeDuration = this.getChildNode(nodeVoice, "duration");
            voice.getDuration().setValue(this.readAttributeInt(nodeDuration, "value"));
            Node nodeDotted = nodeDuration.getAttributes().getNamedItem("dotted");
            if (nodeDotted != null) {
                voice.getDuration().setDotted("dotted".equals(nodeDotted.getTextContent()));
                voice.getDuration().setDoubleDotted("doubleDotted".equals(nodeDotted.getTextContent()));
            }
            if ((nodeDivisionType = this.getChildNode(nodeDuration, "divisionType")) != null) {
                voice.getDuration().getDivision().setEnters(this.readAttributeInt(nodeDivisionType, "enters"));
                voice.getDuration().getDivision().setTimes(this.readAttributeInt(nodeDivisionType, "times"));
            }
            this.readNotes(voice, nodeVoice);
            voice.setEmpty(voice.getNotes().size() == 0);
            Node nodeEmpty = nodeVoice.getAttributes().getNamedItem("empty");
            if (nodeEmpty != null) {
                voice.setEmpty("true".equals(nodeEmpty.getNodeValue()));
            }
            beat.setVoice(index, voice);
            ++index;
            nodeVoice = this.getSiblingNode(nodeVoice.getNextSibling(), "voice");
        }
    }

    private void readNotes(TGVoice voice, Node nodeVoice) {
        int velocity = 95;
        Node nodeNote = this.getChildNode(nodeVoice, "note");
        while (nodeNote != null) {
            TGNote note = this.factory.newNote();
            note.setVoice(voice);
            note.setValue(this.readAttributeInt(nodeNote, "value"));
            Node node = nodeNote.getAttributes().getNamedItem("velocity");
            if (node != null) {
                velocity = this.readInt(node);
            }
            note.setVelocity(velocity);
            note.setString(this.readAttributeInt(nodeNote, "string"));
            node = nodeNote.getAttributes().getNamedItem("tiedNote");
            if (node != null) {
                note.setTiedNote("true".equals(node.getTextContent()));
            }
            TGNoteEffect effect = note.getEffect();
            effect.setVibrato(this.hasChild(nodeNote, "vibrato"));
            effect.setDeadNote(this.hasChild(nodeNote, "deadNote"));
            effect.setSlide(this.hasChild(nodeNote, "slide"));
            effect.setHammer(this.hasChild(nodeNote, "hammer"));
            effect.setGhostNote(this.hasChild(nodeNote, "ghostNote"));
            effect.setAccentuatedNote(this.hasChild(nodeNote, "accentuatedNote"));
            effect.setHeavyAccentuatedNote(this.hasChild(nodeNote, "heavyAccentuatedNote"));
            effect.setPalmMute(this.hasChild(nodeNote, "palmMute"));
            effect.setStaccato(this.hasChild(nodeNote, "staccato"));
            effect.setTapping(this.hasChild(nodeNote, "tapping"));
            effect.setSlapping(this.hasChild(nodeNote, "slapping"));
            effect.setPopping(this.hasChild(nodeNote, "popping"));
            effect.setFadeIn(this.hasChild(nodeNote, "fadeIn"));
            effect.setLetRing(this.hasChild(nodeNote, "letRing"));
            node = this.getChildNode(nodeNote, "bend");
            if (node != null) {
                this.readBend(note, node);
            }
            if ((node = this.getChildNode(nodeNote, "tremoloBar")) != null) {
                this.readTremoloBar(note, node);
            }
            if ((node = this.getChildNode(nodeNote, "harmonic")) != null) {
                this.readHarmonic(note, node);
            }
            if ((node = this.getChildNode(nodeNote, "grace")) != null) {
                this.readGrace(note, node);
            }
            if ((node = this.getChildNode(nodeNote, "trill")) != null) {
                this.readTrill(note, node);
            }
            if ((node = this.getChildNode(nodeNote, "tremoloPicking")) != null) {
                this.readTremoloPicking(note, node);
            }
            if (this.hasChild(nodeNote, "alternativeEnharmonic")) {
                note.toggleAltEnharmonic();
            }
            voice.addNote(note);
            nodeNote = this.getSiblingNode(nodeNote.getNextSibling(), "note");
        }
    }

    private void readBend(TGNote note, Node nodeBend) {
        TGEffectBend bend = this.factory.newEffectBend();
        for (TGStream.PositionValue point : this.readPositionValueList(nodeBend)) {
            bend.addPoint(point.getPosition(), point.getValue());
        }
        note.getEffect().setBend(bend);
    }

    private void readTremoloBar(TGNote note, Node nodeTremoloBar) {
        TGEffectTremoloBar tremoloBar = this.factory.newEffectTremoloBar();
        for (TGStream.PositionValue point : this.readPositionValueList(nodeTremoloBar)) {
            tremoloBar.addPoint(point.getPosition(), point.getValue());
        }
        note.getEffect().setTremoloBar(tremoloBar);
    }

    private void readHarmonic(TGNote note, Node nodeHarmonic) {
        TGEffectHarmonic harmonic = this.factory.newEffectHarmonic();
        harmonic.setType((Integer)this.harmonicReadMap.get(this.readAttribute(nodeHarmonic, "type")));
        harmonic.setData(this.readAttributeInt(nodeHarmonic, "data"));
        note.getEffect().setHarmonic(harmonic);
    }

    private void readGrace(TGNote note, Node nodeGrace) {
        TGEffectGrace grace = this.factory.newEffectGrace();
        grace.setFret(this.readAttributeInt(nodeGrace, "fret"));
        grace.setDuration((Integer)this.mapReadGraceDuration.get(this.readAttributeInt(nodeGrace, "duration")));
        grace.setDynamic(this.readAttributeInt(nodeGrace, "dynamic"));
        grace.setTransition((Integer)this.mapReadTransition.get(this.readAttribute(nodeGrace, "transition")));
        grace.setOnBeat("true".equals(this.readAttribute(nodeGrace, "onBeat")));
        grace.setDead("true".equals(this.readAttribute(nodeGrace, "dead")));
        note.getEffect().setGrace(grace);
    }

    private void readTrill(TGNote note, Node nodeTrill) {
        TGEffectTrill trill = this.factory.newEffectTrill();
        trill.setFret(this.readAttributeInt(nodeTrill, "fret"));
        TGDuration duration = this.factory.newDuration();
        duration.setValue(this.readAttributeInt(nodeTrill, "duration"));
        trill.setDuration(duration);
        note.getEffect().setTrill(trill);
    }

    private void readTremoloPicking(TGNote note, Node nodeTremoloPicking) {
        TGEffectTremoloPicking picking = this.factory.newEffectTremoloPicking();
        TGDuration duration = this.factory.newDuration();
        duration.setValue(this.readAttributeInt(nodeTremoloPicking, "duration"));
        picking.setDuration(duration);
        note.getEffect().setTremoloPicking(picking);
    }

    private List<TGStream.PositionValue> readPositionValueList(Node nodeList) {
        ArrayList<TGStream.PositionValue> list = new ArrayList<TGStream.PositionValue>();
        Node nodePoint = this.getChildNode(nodeList, "point");
        while (nodePoint != null) {
            list.add(new TGStream.PositionValue(this, this.readAttributeInt(nodePoint, "position"), this.readAttributeInt(nodePoint, "value")));
            nodePoint = this.getSiblingNode(nodePoint.getNextSibling(), "point");
        }
        return list;
    }
}

