/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.graphics.command;

import app.tuxguitar.graphics.command.TGPaintCommand;
import app.tuxguitar.ui.resource.UIPainter;

public class TGPaintModel
implements TGPaintCommand {
    private TGPaintCommand[] commands;

    public TGPaintModel(TGPaintCommand ... commands) {
        this.commands = commands;
    }

    @Override
    public void paint(UIPainter painter, float x, float y, float scale) {
        for (TGPaintCommand command : this.commands) {
            command.paint(painter, x, y, scale);
        }
    }

    @Override
    public float getMaximumX() {
        Float maximum = null;
        for (TGPaintCommand command : this.commands) {
            Float current = Float.valueOf(command.getMaximumX());
            if (maximum != null && !(current.floatValue() > maximum.floatValue())) continue;
            maximum = current;
        }
        return maximum != null ? maximum.floatValue() : 0.0f;
    }

    @Override
    public float getMaximumY() {
        Float maximum = null;
        for (TGPaintCommand command : this.commands) {
            Float current = Float.valueOf(command.getMaximumY());
            if (maximum != null && !(current.floatValue() > maximum.floatValue())) continue;
            maximum = current;
        }
        return maximum != null ? maximum.floatValue() : 0.0f;
    }

    @Override
    public float getMinimumX() {
        Float minimum = null;
        for (TGPaintCommand command : this.commands) {
            Float current = Float.valueOf(command.getMinimumX());
            if (minimum != null && !(current.floatValue() < minimum.floatValue())) continue;
            minimum = current;
        }
        return minimum != null ? minimum.floatValue() : 0.0f;
    }

    @Override
    public float getMinimumY() {
        Float minimum = null;
        for (TGPaintCommand command : this.commands) {
            Float current = Float.valueOf(command.getMinimumY());
            if (minimum != null && !(current.floatValue() < minimum.floatValue())) continue;
            minimum = current;
        }
        return minimum != null ? minimum.floatValue() : 0.0f;
    }

    public float getWidth() {
        return this.getMaximumX() - this.getMinimumX();
    }

    public float getHeight() {
        return this.getMaximumY() - this.getMinimumY();
    }
}

