/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextWriterBase;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

class RTFWriter
extends StyledTextWriterBase {
    static final int DEFAULT_FOREGROUND = 0;
    static final int DEFAULT_BACKGROUND = 1;
    List<Color> colorTable = new ArrayList<Color>();
    List<Font> fontTable = new ArrayList<Font>();

    public RTFWriter(StyledText styledText, int start, int length) {
        super(styledText, start, length);
        this.colorTable.add(this.styledText.getForeground());
        this.colorTable.add(this.styledText.getBackground());
        this.fontTable.add(this.styledText.getFont());
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.writeHeader();
            this.write("\n}}\u0000");
            super.close();
        }
    }

    @Override
    void writeHeader() {
        StringBuilder header = new StringBuilder();
        FontData fontData = this.styledText.getFont().getFontData()[0];
        header.append("{\\rtf1\\ansi");
        String cpg = System.getProperty("file.encoding").toLowerCase();
        if (cpg.startsWith("cp") || cpg.startsWith("ms")) {
            cpg = cpg.substring(2, cpg.length());
            header.append("\\ansicpg");
            header.append(cpg);
        }
        header.append("\\uc1\\deff0{\\fonttbl{\\f0\\fnil ");
        header.append(fontData.getName());
        header.append(";");
        for (int i = 1; i < this.fontTable.size(); ++i) {
            header.append("\\f");
            header.append(i);
            header.append(" ");
            FontData fd = this.fontTable.get(i).getFontData()[0];
            header.append(fd.getName());
            header.append(";");
        }
        header.append("}}\n{\\colortbl");
        for (Color color : this.colorTable) {
            header.append("\\red");
            header.append(color.getRed());
            header.append("\\green");
            header.append(color.getGreen());
            header.append("\\blue");
            header.append(color.getBlue());
            header.append(";");
        }
        header.append("}\n{\\f0\\fs");
        header.append(fontData.getHeight() * 2);
        header.append(" ");
        this.write(header.toString(), 0);
    }

    @Override
    public void writeLineDelimiter(String lineDelimiter) {
        if (this.isClosed()) {
            SWT.error(39);
        }
        this.write(lineDelimiter);
        this.write("\\par ");
    }

    @Override
    String writeLineStart(Color lineBackground, int indent, int verticalIndent, int alignment, boolean justify) {
        this.write("\\fi");
        this.write(indent);
        switch (alignment) {
            case 16384: {
                this.write("\\ql");
                break;
            }
            case 0x1000000: {
                this.write("\\qc");
                break;
            }
            case 131072: {
                this.write("\\qr");
            }
        }
        if (justify) {
            this.write("\\qj");
        }
        this.write(" ");
        if (lineBackground != null) {
            this.write("{\\chshdng0\\chcbpat");
            this.write(this.getColorIndex(lineBackground, 1));
            this.write(" ");
        }
        return lineBackground == null ? "" : "}";
    }

    @Override
    String writeSpanStart(StyleRange style) {
        this.write("{\\cf");
        this.write(this.getColorIndex(style.foreground, 0));
        int colorIndex = this.getColorIndex(style.background, 1);
        if (colorIndex != 1) {
            this.write("\\chshdng0\\chcbpat");
            this.write(colorIndex);
        }
        int fontStyle = style.fontStyle;
        Font font = style.font;
        if (font != null) {
            int fontIndex = this.getFontIndex(font);
            this.write("\\f");
            this.write(fontIndex);
            FontData fontData = font.getFontData()[0];
            this.write("\\fs");
            this.write(fontData.getHeight() * 2);
            fontStyle = fontData.getStyle();
        }
        if ((fontStyle & 1) != 0) {
            this.write("\\b");
        }
        if ((fontStyle & 2) != 0) {
            this.write("\\i");
        }
        if (style.underline) {
            this.write("\\ul");
        }
        if (style.strikeout) {
            this.write("\\strike");
        }
        this.write(" ");
        StringBuilder toCloseSpan = new StringBuilder();
        if ((fontStyle & 1) != 0) {
            toCloseSpan.append("\\b0");
        }
        if ((style.fontStyle & 2) != 0) {
            toCloseSpan.append("\\i0");
        }
        if (style.underline) {
            toCloseSpan.append("\\ul0");
        }
        if (style.strikeout) {
            toCloseSpan.append("\\strike0");
        }
        toCloseSpan.append("}");
        return toCloseSpan.toString();
    }

    @Override
    String escapeText(String string) {
        StringBuilder result = new StringBuilder(string.length());
        string.chars().forEach(ch -> {
            if (ch > 127) {
                result.append("\\u");
                result.append(Integer.toString((short)ch));
                result.append('?');
            } else if (ch == 125 || ch == 123 || ch == 92) {
                result.append('\\');
                result.append((char)ch);
            } else {
                result.append((char)ch);
            }
        });
        return result.toString();
    }

    private int getColorIndex(Color color, int defaultIndex) {
        if (color == null) {
            return defaultIndex;
        }
        int index = this.colorTable.indexOf(color);
        if (index == -1) {
            index = this.colorTable.size();
            this.colorTable.add(color);
        }
        return index;
    }

    private int getFontIndex(Font font) {
        int index = this.fontTable.indexOf(font);
        if (index == -1) {
            index = this.fontTable.size();
            this.fontTable.add(font);
        }
        return index;
    }
}

