/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.player.impl.jsa.midiport;

import app.tuxguitar.gm.port.GMReceiver;
import app.tuxguitar.player.impl.jsa.message.MidiMessageFactory;
import app.tuxguitar.util.TGException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.Receiver;

class MidiReceiverImpl
implements GMReceiver {
    private MidiDevice device;
    private Receiver receiver;

    public MidiReceiverImpl(MidiDevice device) {
        this.device = device;
    }

    protected synchronized void open() throws TGException {
        try {
            if (!this.device.isOpen()) {
                this.device.open();
            }
            if (this.receiver == null) {
                this.setReceiver(this.device.getReceiver());
            }
        }
        catch (Throwable e) {
            throw new TGException(e);
        }
    }

    protected synchronized void close() throws Throwable {
        if (this.receiver != null) {
            this.receiver.close();
            this.setReceiver(null);
        }
        if (this.device.isOpen()) {
            this.device.close();
        }
    }

    protected void setReceiver(Receiver receiver) {
        this.receiver = receiver;
    }

    protected Receiver getReceiver() {
        return this.receiver;
    }

    public void sendNoteOn(int channel, int key, int velocity) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageFactory.noteOnGM(channel, key, velocity), -1L);
        }
    }

    public void sendNoteOff(int channel, int key, int velocity) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageFactory.noteOffGM(channel, key, velocity), -1L);
        }
    }

    public void sendControlChange(int channel, int controller, int value) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageFactory.controlChangeGM(channel, controller, value), -1L);
        }
    }

    public void sendProgramChange(int channel, int value) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageFactory.programChangeGM(channel, value), -1L);
        }
    }

    public void sendPitchBend(int channel, int value) {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageFactory.pitchBendGM(channel, value), -1L);
        }
    }

    public void sendSystemReset() {
        if (this.getReceiver() != null) {
            this.getReceiver().send(MidiMessageFactory.systemResetGM(), -1L);
        }
    }

    public void sendAllNotesOff() {
        if (this.getReceiver() != null) {
            for (int channel = 0; channel < 16; ++channel) {
                this.sendControlChange(channel, 123, 0);
            }
        }
    }
}

