/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.player.impl.jsa.message;

import app.tuxguitar.player.impl.jsa.message.MidiControlChangeMessage;
import app.tuxguitar.player.impl.jsa.message.MidiNoteOffMessage;
import app.tuxguitar.player.impl.jsa.message.MidiNoteOnMessage;
import app.tuxguitar.player.impl.jsa.message.MidiPitchBendMessage;
import app.tuxguitar.player.impl.jsa.message.MidiProgramChangeMessage;
import app.tuxguitar.player.impl.jsa.message.MidiSystemResetMessage;
import app.tuxguitar.player.impl.jsa.message.MidiTempoInUsqMessage;
import app.tuxguitar.player.impl.jsa.message.MidiTimeSignatureMessage;
import app.tuxguitar.player.impl.jsa.message.MidiTrackNameMessage;
import app.tuxguitar.song.models.TGTimeSignature;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.ShortMessage;

public class MidiMessageFactory {
    private static int fixValue(int value) {
        int fixedValue = value;
        fixedValue = Math.min(fixedValue, 127);
        fixedValue = Math.max(fixedValue, 0);
        return fixedValue;
    }

    public static MidiMessage noteOn(int channel, int note, int velocity, int voice, boolean bendMode) {
        try {
            return new MidiNoteOnMessage(channel, MidiMessageFactory.fixValue(note), MidiMessageFactory.fixValue(velocity), voice, bendMode);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage noteOff(int channel, int note, int velocity, int voice, boolean bendMode) {
        try {
            return new MidiNoteOffMessage(channel, MidiMessageFactory.fixValue(note), MidiMessageFactory.fixValue(velocity), voice, bendMode);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage pitchBend(int channel, int value, int voice, boolean bendMode) {
        try {
            return new MidiPitchBendMessage(channel, MidiMessageFactory.fixValue(value), voice, bendMode);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage controlChange(int channel, int controller, int value) {
        try {
            return new MidiControlChangeMessage(channel, MidiMessageFactory.fixValue(controller), MidiMessageFactory.fixValue(value));
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage programChange(int channel, int instrument) {
        try {
            return new MidiProgramChangeMessage(channel, MidiMessageFactory.fixValue(instrument));
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage systemReset() {
        try {
            return new MidiSystemResetMessage();
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage trackName(String name) {
        try {
            return new MidiTrackNameMessage(name);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage tempoInUSQ(int usq) {
        try {
            return new MidiTempoInUsqMessage(usq);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage timeSignature(TGTimeSignature tgTimeSignature) {
        try {
            return new MidiTimeSignatureMessage(tgTimeSignature);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage noteOnGM(int channel, int note, int velocity) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(144, channel, MidiMessageFactory.fixValue(note), MidiMessageFactory.fixValue(velocity));
            return shortMessage;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage noteOffGM(int channel, int note, int velocity) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(128, channel, MidiMessageFactory.fixValue(note), MidiMessageFactory.fixValue(velocity));
            return shortMessage;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage pitchBendGM(int channel, int value) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(224, channel, 0, MidiMessageFactory.fixValue(value));
            return shortMessage;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage controlChangeGM(int channel, int controller, int value) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(176, channel, MidiMessageFactory.fixValue(controller), MidiMessageFactory.fixValue(value));
            return shortMessage;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage programChangeGM(int channel, int instrument) {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(192, channel, MidiMessageFactory.fixValue(instrument), 0);
            return shortMessage;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MidiMessage systemResetGM() {
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(255);
            return shortMessage;
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
            return null;
        }
    }
}

