/*
 * Decompiled with CFR 0.152.
 */
package app.tuxguitar.io.ascii;

import app.tuxguitar.io.ascii.ASCIIOutputStream;
import app.tuxguitar.song.managers.TGSongManager;
import app.tuxguitar.song.models.TGBeat;
import app.tuxguitar.song.models.TGMeasure;
import app.tuxguitar.song.models.TGNote;
import app.tuxguitar.song.models.TGSong;
import app.tuxguitar.song.models.TGString;
import app.tuxguitar.song.models.TGTrack;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;

public class ASCIITabOutputStream {
    private static final String[] TONIC_NAMES = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    private static final int MAX_LINE_LENGTH = 80;
    private TGSongManager manager;
    private PrintStream stream;
    private ASCIIOutputStream out;

    public ASCIITabOutputStream(PrintStream stream) {
        this.stream = stream;
    }

    public ASCIITabOutputStream(OutputStream stream) {
        this(new PrintStream(stream));
    }

    public ASCIITabOutputStream(String fileName) throws FileNotFoundException {
        this(new FileOutputStream(fileName));
    }

    public void writeSong(TGSong song) {
        this.manager = new TGSongManager();
        this.out = new ASCIIOutputStream(this.stream);
        this.drawSong(song);
        this.out.flush();
        this.out.close();
    }

    private void drawSong(TGSong song) {
        this.out.drawStringLine("Title: " + song.getName());
        this.out.drawStringLine("Artist: " + song.getArtist());
        this.out.drawStringLine("Album: " + song.getAlbum());
        this.out.drawStringLine("Author: " + song.getAuthor());
        Iterator it = song.getTracks();
        while (it.hasNext()) {
            TGTrack track = (TGTrack)it.next();
            this.out.nextLine();
            this.drawTrack(track);
            this.out.nextLine();
        }
    }

    private void drawTrack(TGTrack track) {
        this.out.nextLine();
        this.out.drawStringLine("Track " + track.getNumber() + ": " + track.getName());
        String[] tuning = new String[track.getStrings().size()];
        int maxTuningLength = 1;
        for (int i = 0; i < track.getStrings().size(); ++i) {
            TGString string = (TGString)track.getStrings().get(i);
            tuning[i] = TONIC_NAMES[string.getValue() % TONIC_NAMES.length];
            maxTuningLength = Math.max(maxTuningLength, tuning[i].length());
        }
        int nextMeasure = 0;
        boolean eof = false;
        while (!eof) {
            this.out.nextLine();
            int index = nextMeasure;
            int measureCount = track.countMeasures();
            this.out.drawTuneSegment("", maxTuningLength);
            for (int j = index; j < measureCount; ++j) {
                TGMeasure measure = track.getMeasure(j);
                this.out.drawSpace();
                this.out.drawSpace();
                TGBeat beat = this.manager.getMeasureManager().getFirstBeat(measure.getBeats());
                while (beat != null) {
                    TGBeat nextBeat = this.manager.getMeasureManager().getNextBeat(measure.getBeats(), beat);
                    int maxOutLength = this.getMaxOutLength(beat, nextBeat, track.getStrings().size());
                    int outLength = this.out.drawChord(beat.getChord());
                    long length = nextBeat != null ? nextBeat.getStart() - beat.getStart() : measure.getStart() + measure.getLength() - beat.getStart();
                    int beatWidth = this.getDurationScaping(length);
                    if (beatWidth <= maxOutLength) {
                        beatWidth = maxOutLength + 1;
                    }
                    this.out.drawSpace(beatWidth - outLength);
                    beat = nextBeat;
                }
                if (this.out.getPosX() > 80) break;
            }
            this.out.nextLine();
            for (int currentString = 0; currentString < track.getStrings().size(); ++currentString) {
                this.out.drawTuneSegment(tuning[currentString], maxTuningLength);
                for (int j = index; j < measureCount; ++j) {
                    TGMeasure measure = track.getMeasure(j);
                    this.drawMeasure(measure, currentString, track.getStrings().size());
                    nextMeasure = j + 1;
                    eof = this.manager.getTrackManager().isLastMeasure(measure);
                    if (this.out.getPosX() > 80) break;
                }
                this.out.drawBarSegment();
                this.out.nextLine();
            }
            this.out.nextLine();
        }
        this.out.nextLine();
    }

    private int getMaxOutLength(TGBeat beat, TGBeat nextBeat, int stringCount) {
        int maxOutLength = beat.getChord() != null ? beat.getChord().getName().length() : 0;
        for (int checkedString = 0; checkedString < stringCount; ++checkedString) {
            int checkedOutLength = this.out.drawNote(this.manager.getMeasureManager().getNote(beat, checkedString + 1), nextBeat != null ? this.manager.getMeasureManager().getNote(nextBeat, checkedString + 1) : null, false);
            if (checkedOutLength <= maxOutLength) continue;
            maxOutLength = checkedOutLength;
        }
        return maxOutLength;
    }

    private void drawMeasure(TGMeasure measure, int currentString, int stringCount) {
        this.out.drawBarSegment();
        this.out.drawStringSegments(1);
        TGBeat beat = this.manager.getMeasureManager().getFirstBeat(measure.getBeats());
        while (beat != null) {
            int outLength = 0;
            TGBeat nextBeat = this.manager.getMeasureManager().getNextBeat(measure.getBeats(), beat);
            TGNote nextNote = nextBeat != null ? this.manager.getMeasureManager().getNote(nextBeat, currentString + 1) : null;
            TGNote note = this.manager.getMeasureManager().getNote(beat, currentString + 1);
            outLength = this.out.drawNote(note, nextNote, true);
            int maxOutLength = this.getMaxOutLength(beat, nextBeat, stringCount);
            long length = nextBeat != null ? nextBeat.getStart() - beat.getStart() : measure.getStart() + measure.getLength() - beat.getStart();
            int beatWidth = this.getDurationScaping(length);
            if (beatWidth <= maxOutLength) {
                beatWidth = maxOutLength + 1;
            }
            this.out.drawStringSegments(beatWidth - outLength);
            beat = nextBeat;
        }
    }

    private int getDurationScaping(long length) {
        int spacing = 6;
        if (length <= 120L) {
            spacing = 1;
        } else if (length <= 240L) {
            spacing = 2;
        } else if (length <= 480L) {
            spacing = 3;
        } else if (length <= 960L) {
            spacing = 4;
        } else if (length <= 1920L) {
            spacing = 5;
        }
        return spacing;
    }
}

