# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QVirtualKeyboardPlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::QVirtualKeyboardPlugin MODULE IMPORTED)

set(_Qt5QVirtualKeyboardPlugin_MODULE_DEPENDENCIES "VirtualKeyboard;Gui;Qml;Core")

foreach(_module_dep ${_Qt5QVirtualKeyboardPlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Gui_FIND_VERSION_EXACT}
            ${_Qt5Gui_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Gui_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Gui_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Gui ${QT_VARIANT_PREFIX}Qt5::QVirtualKeyboardPlugin QVirtualKeyboardPlugin RELEASE "platforminputcontexts/libqtvirtualkeyboardplugin.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Gui_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QVirtualKeyboardPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Gui APPEND PROPERTY QT_ALL_PLUGINS_platforminputcontexts ${QT_VARIANT_PREFIX}Qt5::QVirtualKeyboardPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QVirtualKeyboardPlugin PROPERTY QT_PLUGIN_TYPE "platforminputcontexts")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QVirtualKeyboardPlugin PROPERTY QT_PLUGIN_EXTENDS "-")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QVirtualKeyboardPlugin PROPERTY QT_PLUGIN_CLASS_NAME "QVirtualKeyboardPlugin")
endif()
