# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QGeoServiceProviderFactoryItemsOverlay)
    add_library(${QT_VARIANT_PREFIX}Qt5::QGeoServiceProviderFactoryItemsOverlay MODULE IMPORTED)

set(_Qt5QGeoServiceProviderFactoryItemsOverlay_MODULE_DEPENDENCIES "Location;Location;Location;Positioning;Gui;Core")

foreach(_module_dep ${_Qt5QGeoServiceProviderFactoryItemsOverlay_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Location_FIND_VERSION_EXACT}
            ${_Qt5Location_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Location_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Location_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Location ${QT_VARIANT_PREFIX}Qt5::QGeoServiceProviderFactoryItemsOverlay QGeoServiceProviderFactoryItemsOverlay RELEASE "geoservices/libqtgeoservices_itemsoverlay.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Location_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QGeoServiceProviderFactoryItemsOverlay)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Location APPEND PROPERTY QT_ALL_PLUGINS_geoservices ${QT_VARIANT_PREFIX}Qt5::QGeoServiceProviderFactoryItemsOverlay)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QGeoServiceProviderFactoryItemsOverlay PROPERTY QT_PLUGIN_TYPE "geoservices")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QGeoServiceProviderFactoryItemsOverlay PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QGeoServiceProviderFactoryItemsOverlay PROPERTY QT_PLUGIN_CLASS_NAME "QGeoServiceProviderFactoryItemsOverlay")
endif()
