# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QQmlNativeDebugServiceFactory)
    add_library(${QT_VARIANT_PREFIX}Qt5::QQmlNativeDebugServiceFactory MODULE IMPORTED)

set(_Qt5QQmlNativeDebugServiceFactory_MODULE_DEPENDENCIES "Qml;PacketProtocol;Core")

foreach(_module_dep ${_Qt5QQmlNativeDebugServiceFactory_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Qml_FIND_VERSION_EXACT}
            ${_Qt5Qml_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Qml_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Qml_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Qml ${QT_VARIANT_PREFIX}Qt5::QQmlNativeDebugServiceFactory QQmlNativeDebugServiceFactory RELEASE "qmltooling/libqmldbg_nativedebugger.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Qml_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QQmlNativeDebugServiceFactory)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Qml APPEND PROPERTY QT_ALL_PLUGINS_qmltooling ${QT_VARIANT_PREFIX}Qt5::QQmlNativeDebugServiceFactory)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QQmlNativeDebugServiceFactory PROPERTY QT_PLUGIN_TYPE "qmltooling")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QQmlNativeDebugServiceFactory PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QQmlNativeDebugServiceFactory PROPERTY QT_PLUGIN_CLASS_NAME "QQmlNativeDebugServiceFactory")
endif()
