# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QWindowsVistaStylePlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::QWindowsVistaStylePlugin MODULE IMPORTED)

set(_Qt5QWindowsVistaStylePlugin_MODULE_DEPENDENCIES "Widgets;Gui;Core")

foreach(_module_dep ${_Qt5QWindowsVistaStylePlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Widgets_FIND_VERSION_EXACT}
            ${_Qt5Widgets_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Widgets_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Widgets_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Widgets ${QT_VARIANT_PREFIX}Qt5::QWindowsVistaStylePlugin QWindowsVistaStylePlugin RELEASE "styles/libqwindowsvistastyle.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Widgets_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QWindowsVistaStylePlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Widgets APPEND PROPERTY QT_ALL_PLUGINS_styles ${QT_VARIANT_PREFIX}Qt5::QWindowsVistaStylePlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QWindowsVistaStylePlugin PROPERTY QT_PLUGIN_TYPE "styles")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QWindowsVistaStylePlugin PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QWindowsVistaStylePlugin PROPERTY QT_PLUGIN_CLASS_NAME "QWindowsVistaStylePlugin")
endif()
