# Find the aGrUM includes and library
#
# AGRUM_INCLUDE_DIRS - where to find the includes
# AGRUM_CXX_FLAGS - mandatory CXX flags
# AGRUM_LIBRARY - aGrUM library name
# AGRUM_LIBRARIES - list of qualified libraries to link against
# AGRUM_LIBRARY_DIRS - list of libraries dirs
# AGRUM_VERSION_STRING - versioni
# AGRUM_USE_FILE - include to use agrum
# AGRUM_FOUND - set to 1 if found
#
#
set (AGRUM_FOUND 1)
set (AGRUM_DEFINITIONS "")
set (AGRUM_INCLUDE_DIR "/usr/i686-w64-mingw32/include")
set (AGRUM_INCLUDE_DIRS "/usr/i686-w64-mingw32/include")
set (AGRUM_CXX_FLAGS "")
set (AGRUM_LIBRARY_DIRS "/usr/i686-w64-mingw32/lib")
set (AGRUM_LIB_DIR "/usr/i686-w64-mingw32/lib") # deprecated

set (AGRUM_LIBRARY "agrum")
set (AGRUM_LIBRARY_DEBUG "agrum-dbg")
set (AGRUM_LIBRARIES_DEBUG "agrum-dbg")
set (AGRUM_LIBRARY_RELEASE "agrum")
set (AGRUM_LIBRARIES_RELEASE "agrum")

set (AGRUM_ROOTDIR "/usr/i686-w64-mingw32")
set (AGRUM_VERSION_STRING "2.3.0")
set (AGRUM_VERSION_MAJOR "2")
set (AGRUM_VERSION_MINOR "3")
set (AGRUM_VERSION_PATCH "0")

find_package(OpenMP QUIET)

# Our library dependencies (contains definitions for IMPORTED targets)
foreach (MODULE BASE;BN;MRF;CN;FMDP;ID)
  include ("${CMAKE_CURRENT_LIST_DIR}/agrum${MODULE}-targets.cmake")
endforeach ()
include ("${CMAKE_CURRENT_LIST_DIR}/${AGRUM_LIBRARY}-targets.cmake")
