/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.view;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.GeolocationPermissions;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.lang.reflect.Method;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class QtAndroidWebViewController {
    private final Activity m_activity;
    private final long m_id;
    private boolean m_hasLocationPermission;
    private WebView m_webView = null;
    private static final String TAG = "QtAndroidWebViewController";
    private final int INIT_STATE = 0;
    private final int STARTED_STATE = 1;
    private final int LOADING_STATE = 2;
    private final int FINISHED_STATE = 3;
    private volatile int m_loadingState = 0;
    private volatile int m_progress = 0;
    private volatile int m_frameCount = 0;
    private Method m_webViewOnResume = null;
    private Method m_webViewOnPause = null;
    private Method m_webSettingsSetDisplayZoomControls = null;
    private Method m_webViewEvaluateJavascript = null;
    private final long BLOCKING_TIMEOUT = 250L;

    private native void c_onPageFinished(long var1, String var3);

    private native void c_onPageStarted(long var1, String var3, Bitmap var4);

    private native void c_onProgressChanged(long var1, int var3);

    private native void c_onReceivedIcon(long var1, Bitmap var3);

    private native void c_onReceivedTitle(long var1, String var3);

    private native void c_onRunJavaScriptResult(long var1, long var3, String var5);

    private native void c_onReceivedError(long var1, int var3, String var4, String var5);

    private static native void c_onCookieAdded(long var0, boolean var2, String var3, String var4);

    private static native void c_onCookieRemoved(long var0, boolean var2, String var3, String var4);

    private void resetLoadingState(int n) {
        this.m_progress = 0;
        this.m_frameCount = 0;
        this.m_loadingState = n;
    }

    QtAndroidWebViewController(Activity activity, long l) {
        this.m_activity = activity;
        this.m_id = l;
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView = new WebView((Context)QtAndroidWebViewController.this.m_activity);
                QtAndroidWebViewController.this.m_hasLocationPermission = QtAndroidWebViewController.hasLocationPermission((View)QtAndroidWebViewController.this.m_webView);
                WebSettings webSettings = QtAndroidWebViewController.this.m_webView.getSettings();
                webSettings.setDatabaseEnabled(true);
                webSettings.setDomStorageEnabled(true);
                if (Build.VERSION.SDK_INT > 10) {
                    try {
                        QtAndroidWebViewController.this.m_webViewOnResume = QtAndroidWebViewController.this.m_webView.getClass().getMethod("onResume", new Class[0]);
                        QtAndroidWebViewController.this.m_webViewOnPause = QtAndroidWebViewController.this.m_webView.getClass().getMethod("onPause", new Class[0]);
                        QtAndroidWebViewController.this.m_webSettingsSetDisplayZoomControls = webSettings.getClass().getMethod("setDisplayZoomControls", Boolean.TYPE);
                        if (Build.VERSION.SDK_INT > 18) {
                            QtAndroidWebViewController.this.m_webViewEvaluateJavascript = QtAndroidWebViewController.this.m_webView.getClass().getMethod("evaluateJavascript", String.class, ValueCallback.class);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                webSettings.setGeolocationEnabled(QtAndroidWebViewController.this.m_hasLocationPermission);
                webSettings.setJavaScriptEnabled(true);
                if (QtAndroidWebViewController.this.m_webSettingsSetDisplayZoomControls != null) {
                    try {
                        QtAndroidWebViewController.this.m_webSettingsSetDisplayZoomControls.invoke((Object)webSettings, false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                webSettings.setBuiltInZoomControls(true);
                webSettings.setPluginState(WebSettings.PluginState.ON);
                QtAndroidWebViewController.this.m_webView.setWebViewClient((WebViewClient)new QtAndroidWebViewClient());
                QtAndroidWebViewController.this.m_webView.setWebChromeClient((WebChromeClient)new QtAndroidWebChromeClient());
                semaphore.release();
            }
        });
        try {
            semaphore.acquire();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void setLocalStorageEnabled(final boolean bl) {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebSettings webSettings = QtAndroidWebViewController.this.m_webView.getSettings();
                webSettings.setDatabaseEnabled(bl);
                webSettings.setDomStorageEnabled(bl);
            }
        });
    }

    boolean isLocalStorageEnabled() {
        final boolean[] blArray = new boolean[]{true};
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebSettings webSettings = QtAndroidWebViewController.this.m_webView.getSettings();
                blArray[0] = webSettings.getDatabaseEnabled() && webSettings.getDomStorageEnabled();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return blArray[0];
    }

    void setJavaScriptEnabled(final boolean bl) {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebSettings webSettings = QtAndroidWebViewController.this.m_webView.getSettings();
                webSettings.setJavaScriptEnabled(bl);
            }
        });
    }

    boolean isJavaScriptEnabled() {
        final boolean[] blArray = new boolean[]{true};
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebSettings webSettings = QtAndroidWebViewController.this.m_webView.getSettings();
                blArray[0] = webSettings.getJavaScriptEnabled();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return blArray[0];
    }

    void setAllowFileAccessFromFileURLs(final boolean bl) {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebSettings webSettings = QtAndroidWebViewController.this.m_webView.getSettings();
                webSettings.setAllowFileAccessFromFileURLs(bl);
            }
        });
    }

    boolean isAllowFileAccessFromFileURLsEnabled() {
        final boolean[] blArray = new boolean[]{true};
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebSettings webSettings = QtAndroidWebViewController.this.m_webView.getSettings();
                blArray[0] = webSettings.getAllowFileAccessFromFileURLs();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return blArray[0];
    }

    void setAllowFileAccess(final boolean bl) {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebSettings webSettings = QtAndroidWebViewController.this.m_webView.getSettings();
                webSettings.setAllowFileAccess(bl);
            }
        });
    }

    boolean isAllowFileAccessEnabled() {
        final boolean[] blArray = new boolean[]{true};
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                WebSettings webSettings = QtAndroidWebViewController.this.m_webView.getSettings();
                blArray[0] = webSettings.getAllowFileAccess();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return blArray[0];
    }

    String getUserAgent() {
        final String[] stringArray = new String[]{""};
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                stringArray[0] = QtAndroidWebViewController.this.m_webView.getSettings().getUserAgentString();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray[0];
    }

    void setUserAgent(final String string) {
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.getSettings().setUserAgentString(string);
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void loadUrl(final String string) {
        if (string == null) {
            return;
        }
        this.resetLoadingState(1);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.loadUrl(string);
            }
        });
    }

    void loadData(final String string, final String string2, final String string3) {
        if (string == null) {
            return;
        }
        this.resetLoadingState(1);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.loadData(string, string2, string3);
            }
        });
    }

    void loadDataWithBaseURL(final String string, final String string2, final String string3, final String string4, final String string5) {
        if (string2 == null) {
            return;
        }
        this.resetLoadingState(1);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.loadDataWithBaseURL(string, string2, string3, string4, string5);
            }
        });
    }

    void goBack() {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.goBack();
            }
        });
    }

    boolean canGoBack() {
        final boolean[] blArray = new boolean[]{false};
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                blArray[0] = QtAndroidWebViewController.this.m_webView.canGoBack();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return blArray[0];
    }

    void goForward() {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.goForward();
            }
        });
    }

    boolean canGoForward() {
        final boolean[] blArray = new boolean[]{false};
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                blArray[0] = QtAndroidWebViewController.this.m_webView.canGoForward();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return blArray[0];
    }

    void stopLoading() {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.stopLoading();
            }
        });
    }

    void reload() {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.reload();
            }
        });
    }

    String getTitle() {
        final String[] stringArray = new String[]{""};
        final Semaphore semaphore = new Semaphore(0);
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                stringArray[0] = QtAndroidWebViewController.this.m_webView.getTitle();
                semaphore.release();
            }
        });
        try {
            semaphore.tryAcquire(250L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray[0];
    }

    int getProgress() {
        return this.m_progress;
    }

    boolean isLoading() {
        return this.m_loadingState == 2 || this.m_loadingState == 1 || this.m_progress > 0 && this.m_progress < 100;
    }

    void runJavaScript(final String string, final long l) {
        if (string == null) {
            return;
        }
        if (Build.VERSION.SDK_INT < 19 || this.m_webViewEvaluateJavascript == null) {
            return;
        }
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    QtAndroidWebViewController.this.m_webViewEvaluateJavascript.invoke((Object)QtAndroidWebViewController.this.m_webView, string, l == -1L ? null : new ValueCallback<String>(){

                        public void onReceiveValue(String string) {
                            QtAndroidWebViewController.this.c_onRunJavaScriptResult(QtAndroidWebViewController.this.m_id, l, string);
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    WebView getWebView() {
        return this.m_webView;
    }

    void onPause() {
        if (this.m_webViewOnPause == null) {
            return;
        }
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    QtAndroidWebViewController.this.m_webViewOnPause.invoke((Object)QtAndroidWebViewController.this.m_webView, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    void onResume() {
        if (this.m_webViewOnResume == null) {
            return;
        }
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    QtAndroidWebViewController.this.m_webViewOnResume.invoke((Object)QtAndroidWebViewController.this.m_webView, new Object[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private static boolean hasLocationPermission(View view) {
        String string = view.getContext().getPackageName();
        PackageManager packageManager = view.getContext().getPackageManager();
        return packageManager.checkPermission("android.permission.ACCESS_FINE_LOCATION", string) == 0;
    }

    void destroy() {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                QtAndroidWebViewController.this.m_webView.destroy();
            }
        });
    }

    private static void setCookieImp(String string, String string2, ValueCallback<Boolean> valueCallback) {
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        try {
            cookieManager.setCookie(string, string2, valueCallback);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static void setCookie(final long l, final String string, final String string2) {
        QtAndroidWebViewController.setCookieImp(string, string2, new ValueCallback<Boolean>(){

            public void onReceiveValue(Boolean bl) {
                try {
                    QtAndroidWebViewController.c_onCookieAdded(l, bl, string, string2.split("=")[0]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }

    private static boolean hasValidCookie(String string, String string2) {
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.removeExpiredCookie();
        boolean bl = false;
        String string3 = cookieManager.getCookie(string);
        String string4 = null;
        if (string3 != null) {
            String[] stringArray;
            for (String string5 : stringArray = string3.split(";")) {
                if (!string5.startsWith(string2)) continue;
                string4 = string5;
                bl = !string5.endsWith("=");
                break;
            }
        }
        return bl;
    }

    private static String getExpireString() {
        return "expires=\"Thu, 1 Jan 1970 00:00:00 GMT\"";
    }

    static void removeCookie(final long l, final String string, final String string2) {
        final boolean bl = QtAndroidWebViewController.hasValidCookie(string, string2);
        if (bl) {
            String string3 = string2 + ";" + QtAndroidWebViewController.getExpireString();
            QtAndroidWebViewController.setCookieImp(string, string3, new ValueCallback<Boolean>(){

                public void onReceiveValue(Boolean bl3) {
                    try {
                        boolean bl2 = bl && !QtAndroidWebViewController.hasValidCookie(string, string2);
                        QtAndroidWebViewController.c_onCookieRemoved(l, bl2, string, string2.split("=")[0]);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
    }

    static void removeCookies() {
        try {
            CookieManager.getInstance().removeAllCookies(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class QtAndroidWebChromeClient
    extends WebChromeClient {
        QtAndroidWebChromeClient() {
        }

        public void onProgressChanged(WebView webView, int n) {
            super.onProgressChanged(webView, n);
            QtAndroidWebViewController.this.m_progress = n;
            QtAndroidWebViewController.this.c_onProgressChanged(QtAndroidWebViewController.this.m_id, n);
        }

        public void onReceivedIcon(WebView webView, Bitmap bitmap) {
            super.onReceivedIcon(webView, bitmap);
            QtAndroidWebViewController.this.c_onReceivedIcon(QtAndroidWebViewController.this.m_id, bitmap);
        }

        public void onReceivedTitle(WebView webView, String string) {
            super.onReceivedTitle(webView, string);
            QtAndroidWebViewController.this.c_onReceivedTitle(QtAndroidWebViewController.this.m_id, string);
        }

        public void onGeolocationPermissionsShowPrompt(String string, GeolocationPermissions.Callback callback) {
            callback.invoke(string, QtAndroidWebViewController.this.m_hasLocationPermission, false);
        }
    }

    private class QtAndroidWebViewClient
    extends WebViewClient {
        QtAndroidWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string) {
            if (URLUtil.isValidUrl((String)string)) {
                return false;
            }
            try {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string));
                webView.getContext().startActivity(intent);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }

        public void onLoadResource(WebView webView, String string) {
            super.onLoadResource(webView, string);
        }

        public void onPageFinished(WebView webView, String string) {
            super.onPageFinished(webView, string);
            QtAndroidWebViewController.this.m_frameCount = 0;
            if (QtAndroidWebViewController.this.m_loadingState == 0) {
                QtAndroidWebViewController.this.m_loadingState = 3;
            } else {
                QtAndroidWebViewController.this.m_loadingState = 3;
                QtAndroidWebViewController.this.c_onPageFinished(QtAndroidWebViewController.this.m_id, string);
            }
        }

        public void onPageStarted(WebView webView, String string, Bitmap bitmap) {
            super.onPageStarted(webView, string, bitmap);
            if (++QtAndroidWebViewController.this.m_frameCount == 1) {
                QtAndroidWebViewController.this.m_loadingState = 2;
                QtAndroidWebViewController.this.c_onPageStarted(QtAndroidWebViewController.this.m_id, string, bitmap);
            }
        }

        public void onReceivedError(WebView webView, int n, String string, String string2) {
            super.onReceivedError(webView, n, string, string2);
            QtAndroidWebViewController.this.resetLoadingState(0);
            QtAndroidWebViewController.this.c_onReceivedError(QtAndroidWebViewController.this.m_id, n, string, string2);
        }
    }
}

