/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.app.UiModeManager;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.view.Window;
import java.util.HashMap;
import org.qtproject.qt.android.ExtractStyle;
import org.qtproject.qt.android.QtAccessibilityDelegate;
import org.qtproject.qt.android.QtDisplayManager;
import org.qtproject.qt.android.QtInputDelegate;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtWindow;

abstract class QtActivityDelegateBase {
    protected final Activity m_activity;
    protected final HashMap<Integer, QtWindow> m_topLevelWindows = new HashMap();
    protected final QtDisplayManager m_displayManager;
    protected final QtInputDelegate m_inputDelegate;
    protected final QtAccessibilityDelegate m_accessibilityDelegate;
    private boolean m_membersInitialized = false;
    private boolean m_contextMenuVisible = false;

    static native boolean canOverrideColorSchemeHint();

    static native void updateUiContrast(float var0);

    abstract void startNativeApplicationImpl(String var1, String var2);

    void setUpLayout() {
    }

    void setUpSplashScreen(int n) {
    }

    void hideSplashScreen(int n) {
    }

    void setActionBarVisibility(boolean bl) {
    }

    QtActivityDelegateBase(Activity activity) {
        this.m_activity = activity;
        QtNative.setActivity(this.m_activity);
        this.m_displayManager = new QtDisplayManager(this.m_activity);
        this.m_inputDelegate = new QtInputDelegate(this.m_displayManager::reinstateFullScreen);
        this.m_accessibilityDelegate = new QtAccessibilityDelegate();
    }

    QtDisplayManager displayManager() {
        return this.m_displayManager;
    }

    QtInputDelegate getInputDelegate() {
        return this.m_inputDelegate;
    }

    void setContextMenuVisible(boolean bl) {
        this.m_contextMenuVisible = bl;
    }

    boolean isContextMenuVisible() {
        return this.m_contextMenuVisible;
    }

    void startNativeApplication(String string2, String string3) {
        if (this.m_membersInitialized) {
            return;
        }
        this.initMembers();
        this.startNativeApplicationImpl(string2, string3);
    }

    void initMembers() {
        this.m_membersInitialized = true;
        this.m_topLevelWindows.clear();
        this.m_displayManager.registerDisplayListener();
        this.m_inputDelegate.initInputMethodManager(this.m_activity);
        try {
            PackageManager packageManager = this.m_activity.getPackageManager();
            ActivityInfo activityInfo = packageManager.getActivityInfo(this.m_activity.getComponentName(), 0);
            this.m_inputDelegate.setSoftInputMode(activityInfo.softInputMode);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        this.setUpLayout();
    }

    void hideSplashScreen() {
        this.hideSplashScreen(0);
    }

    void handleUiModeChange() {
        Window window;
        Resources resources = this.m_activity.getResources();
        Configuration configuration = resources.getConfiguration();
        int n = configuration.uiMode & 0x30;
        if (this.m_displayManager.decorFitsSystemWindows()) {
            window = this.m_activity.getWindow();
            QtDisplayManager.enableSystemBarsBackgroundDrawing(window);
            int n2 = QtDisplayManager.getThemeDefaultStatusBarColor(this.m_activity);
            QtDisplayManager.setStatusBarColor(window, n2);
            int n3 = QtDisplayManager.getThemeDefaultNavigationBarColor(this.m_activity);
            QtDisplayManager.setNavigationBarColor(window, n3);
        }
        if (QtActivityDelegateBase.canOverrideColorSchemeHint()) {
            boolean bl = n == 16;
            QtDisplayManager.setStatusBarColorHint(this.m_activity, bl);
            QtDisplayManager.setNavigationBarColorHint(this.m_activity, bl);
        }
        switch (n) {
            case 16: {
                ExtractStyle.runIfNeeded((Context)this.m_activity, false);
                QtDisplayManager.handleUiDarkModeChanged(0);
                break;
            }
            case 32: {
                ExtractStyle.runIfNeeded((Context)this.m_activity, true);
                QtDisplayManager.handleUiDarkModeChanged(1);
            }
        }
        if (Build.VERSION.SDK_INT >= 34) {
            window = (UiModeManager)this.m_activity.getSystemService("uimode");
            QtActivityDelegateBase.updateUiContrast(window.getContrast());
        }
    }
}

