# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QtVirtualKeyboardHangulPlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::QtVirtualKeyboardHangulPlugin MODULE IMPORTED)

set(_Qt5QtVirtualKeyboardHangulPlugin_MODULE_DEPENDENCIES "VirtualKeyboard;Gui;Qml;Core")

foreach(_module_dep ${_Qt5QtVirtualKeyboardHangulPlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5VirtualKeyboard_FIND_VERSION_EXACT}
            ${_Qt5VirtualKeyboard_DEPENDENCIES_FIND_QUIET}
            ${_Qt5VirtualKeyboard_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_VirtualKeyboard_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::VirtualKeyboard ${QT_VARIANT_PREFIX}Qt5::QtVirtualKeyboardHangulPlugin QtVirtualKeyboardHangulPlugin RELEASE "virtualkeyboard/libqtvirtualkeyboard_hangul.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5VirtualKeyboard_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QtVirtualKeyboardHangulPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::VirtualKeyboard APPEND PROPERTY QT_ALL_PLUGINS_virtualkeyboard ${QT_VARIANT_PREFIX}Qt5::QtVirtualKeyboardHangulPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QtVirtualKeyboardHangulPlugin PROPERTY QT_PLUGIN_TYPE "virtualkeyboard")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QtVirtualKeyboardHangulPlugin PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QtVirtualKeyboardHangulPlugin PROPERTY QT_PLUGIN_CLASS_NAME "QtVirtualKeyboardHangulPlugin")
endif()
