# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::QSvgPlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::QSvgPlugin MODULE IMPORTED)

set(_Qt5QSvgPlugin_MODULE_DEPENDENCIES "Svg;Gui;Core")

foreach(_module_dep ${_Qt5QSvgPlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Gui_FIND_VERSION_EXACT}
            ${_Qt5Gui_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Gui_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Gui_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Gui ${QT_VARIANT_PREFIX}Qt5::QSvgPlugin QSvgPlugin RELEASE "imageformats/libqsvg.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Gui_PLUGINS ${QT_VARIANT_PREFIX}Qt5::QSvgPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Gui APPEND PROPERTY QT_ALL_PLUGINS_imageformats ${QT_VARIANT_PREFIX}Qt5::QSvgPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QSvgPlugin PROPERTY QT_PLUGIN_TYPE "imageformats")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QSvgPlugin PROPERTY QT_PLUGIN_EXTENDS "Qt::Svg")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::QSvgPlugin PROPERTY QT_PLUGIN_CLASS_NAME "QSvgPlugin")
endif()
