# Some Qt modules also load plugin target in extra config, so check whether the target already exists
if(NOT TARGET ${QT_VARIANT_PREFIX}Qt5::genericSensorPlugin)
    add_library(${QT_VARIANT_PREFIX}Qt5::genericSensorPlugin MODULE IMPORTED)

set(_Qt5genericSensorPlugin_MODULE_DEPENDENCIES "Sensors;Core")

foreach(_module_dep ${_Qt5genericSensorPlugin_MODULE_DEPENDENCIES})
    if(NOT ${QT_VARIANT_PREFIX}Qt5${_module_dep}_FOUND)
        find_package(${QT_VARIANT_PREFIX}Qt5${_module_dep}
             ${_Qt5Sensors_FIND_VERSION_EXACT}
            ${_Qt5Sensors_DEPENDENCIES_FIND_QUIET}
            ${_Qt5Sensors_FIND_DEPENDENCIES_REQUIRED}
            PATHS "${CMAKE_CURRENT_LIST_DIR}/.." NO_DEFAULT_PATH
        )
    endif()
endforeach()

    _populate_Sensors_plugin_properties_static(${QT_VARIANT_PREFIX}Qt5::Sensors ${QT_VARIANT_PREFIX}Qt5::genericSensorPlugin genericSensorPlugin RELEASE "sensors/libqtsensors_generic.a")


list(APPEND ${QT_VARIANT_PREFIX}Qt5Sensors_PLUGINS ${QT_VARIANT_PREFIX}Qt5::genericSensorPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::Sensors APPEND PROPERTY QT_ALL_PLUGINS_sensors ${QT_VARIANT_PREFIX}Qt5::genericSensorPlugin)
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::genericSensorPlugin PROPERTY QT_PLUGIN_TYPE "sensors")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::genericSensorPlugin PROPERTY QT_PLUGIN_EXTENDS "")
set_property(TARGET ${QT_VARIANT_PREFIX}Qt5::genericSensorPlugin PROPERTY QT_PLUGIN_CLASS_NAME "genericSensorPlugin")
endif()
