/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.positioning;

import android.content.Context;
import android.location.GnssStatus;
import android.location.GpsSatellite;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.altitude.AltitudeConverter;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

class QtPositioning
implements LocationListener {
    private static final String TAG = "qt.positioning.android";
    static LocationManager locationManager = null;
    static Object m_syncObject = new Object();
    static HashMap<Integer, QtPositioning> runningListeners = new HashMap();
    private int nativeClassReference = 0;
    private int expectedProviders = 0;
    static final int QT_GPS_PROVIDER = 1;
    static final int QT_NETWORK_PROVIDER = 2;
    static final int QT_ACCESS_ERROR = 0;
    static final int QT_CLOSED_ERROR = 1;
    static final int QT_POSITION_UNKNOWN_SOURCE_ERROR = 2;
    static final int QT_POSITION_NO_ERROR = 3;
    static final int QT_SATELLITE_NO_ERROR = 2;
    static final int QT_SATELLITE_UNKNOWN_SOURCE_ERROR = -1;
    private boolean isSingleUpdate = false;
    private int updateIntervalTime = 0;
    private Location lastGps = null;
    private Location lastNetwork = null;
    private boolean isSatelliteUpdate = false;
    private boolean useAltitudeConverter = false;
    private PositioningLooperBase looperThread = Build.VERSION.SDK_INT <= 23 ? new PositioningLooperGps() : new PositioningLooperGnss();
    private boolean isLocationProvidersDisabledInvoked = false;
    private static Context appContext = null;
    private static AltitudeConverter altitudeConverter = null;

    static void setContext(Context context) {
        try {
            appContext = context;
            locationManager = (LocationManager)context.getSystemService("location");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static int[] providerList() {
        if (locationManager == null) {
            Log.w((String)TAG, (String)"No locationManager available in QtPositioning");
            return new int[0];
        }
        List list = locationManager.getProviders(true);
        int[] nArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            nArray[i] = ((String)list.get(i)).equals("gps") ? 0 : (((String)list.get(i)).equals("network") ? 1 : (((String)list.get(i)).equals("passive") ? 2 : -1));
        }
        return nArray;
    }

    private static void addMslAltitude(Location location) {
        if (Build.VERSION.SDK_INT >= 34) {
            if (location.hasMslAltitude()) {
                return;
            }
            if (altitudeConverter == null) {
                altitudeConverter = new AltitudeConverter();
            }
            try {
                altitudeConverter.addMslAltitudeToLocation(appContext, location);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static Location lastKnownPosition(boolean bl, boolean bl2) {
        Location location = null;
        Location location2 = null;
        try {
            location = locationManager.getLastKnownLocation("gps");
            if (bl2) {
                QtPositioning.addMslAltitude(location);
            }
        }
        catch (Exception exception) {
            if (bl) {
                exception.printStackTrace();
            }
            location = null;
        }
        if (!bl) {
            try {
                location2 = locationManager.getLastKnownLocation("network");
                if (bl2) {
                    QtPositioning.addMslAltitude(location2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                location2 = null;
            }
        }
        if (location != null && location2 != null) {
            long l = location2.getTime() - location.getTime();
            if (l < 14400000L) {
                return location;
            }
            return location2;
        }
        if (location != null) {
            return location;
        }
        if (location2 != null) {
            return location2;
        }
        return null;
    }

    private static boolean expectedProvidersAvailable(int n) {
        List list = locationManager.getProviders(true);
        if ((n & 1) > 0 && list.contains("gps")) {
            return true;
        }
        return (n & 2) > 0 && list.contains("network");
    }

    private static void addActiveListener(QtPositioning qtPositioning, String string, long l, float f) {
        int n = qtPositioning.nativeClassReference;
        qtPositioning.setActiveLooper(true);
        if (runningListeners.containsKey(n) && runningListeners.get(n) != qtPositioning) {
            QtPositioning.removeActiveListener(n);
        }
        locationManager.requestLocationUpdates(string, l, f, (LocationListener)qtPositioning, qtPositioning.looper());
        runningListeners.put(n, qtPositioning);
    }

    private static void removeActiveListener(QtPositioning qtPositioning) {
        QtPositioning.removeActiveListener(qtPositioning.nativeClassReference);
    }

    private static void removeActiveListener(int n) {
        QtPositioning qtPositioning = runningListeners.remove(n);
        if (qtPositioning != null) {
            locationManager.removeUpdates((LocationListener)qtPositioning);
            qtPositioning.setActiveLooper(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int startUpdates(int n, int n2, int n3, boolean bl) {
        Object object = m_syncObject;
        synchronized (object) {
            try {
                boolean bl2 = false;
                Throwable throwable = null;
                QtPositioning qtPositioning = new QtPositioning();
                qtPositioning.nativeClassReference = n;
                qtPositioning.expectedProviders = n2;
                qtPositioning.isSatelliteUpdate = false;
                qtPositioning.useAltitudeConverter = bl;
                if (n3 == 0) {
                    n3 = 50;
                }
                qtPositioning.updateIntervalTime = n3;
                if ((n2 & 1) > 0) {
                    Log.d((String)TAG, (String)("Regular updates using GPS " + n3));
                    try {
                        QtPositioning.addActiveListener(qtPositioning, "gps", n3, 0.0f);
                        bl2 = true;
                    }
                    catch (SecurityException securityException) {
                        throwable = securityException;
                    }
                }
                if ((n2 & 2) > 0) {
                    Log.d((String)TAG, (String)("Regular updates using network " + n3));
                    try {
                        QtPositioning.addActiveListener(qtPositioning, "network", n3, 0.0f);
                        bl2 = true;
                    }
                    catch (SecurityException securityException) {
                        throwable = securityException;
                    }
                }
                if (!bl2 && throwable != null) {
                    throwable.printStackTrace();
                    QtPositioning.removeActiveListener(qtPositioning);
                    return 0;
                }
                if (!QtPositioning.expectedProvidersAvailable(n2)) {
                    return 1;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 2;
            }
            return 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopUpdates(int n) {
        Object object = m_syncObject;
        synchronized (object) {
            try {
                Log.d((String)TAG, (String)"Stopping updates");
                QtPositioning.removeActiveListener(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int requestUpdate(int n, int n2, int n3, boolean bl) {
        Object object = m_syncObject;
        synchronized (object) {
            try {
                boolean bl2 = false;
                SecurityException securityException = null;
                QtPositioning qtPositioning = new QtPositioning();
                qtPositioning.nativeClassReference = n;
                qtPositioning.isSingleUpdate = true;
                qtPositioning.expectedProviders = n2;
                qtPositioning.isSatelliteUpdate = false;
                qtPositioning.useAltitudeConverter = bl;
                if ((n2 & 1) > 0) {
                    Log.d((String)TAG, (String)"Single update using GPS");
                    try {
                        QtPositioning.addActiveListener(qtPositioning, "gps", n3, 0.0f);
                        bl2 = true;
                    }
                    catch (SecurityException securityException2) {
                        securityException = securityException2;
                    }
                }
                if ((n2 & 2) > 0) {
                    Log.d((String)TAG, (String)"Single update using network");
                    try {
                        QtPositioning.addActiveListener(qtPositioning, "network", n3, 0.0f);
                        bl2 = true;
                    }
                    catch (SecurityException securityException3) {
                        securityException = securityException3;
                    }
                }
                if (!bl2 && securityException != null) {
                    securityException.printStackTrace();
                    QtPositioning.removeActiveListener(qtPositioning);
                    return 0;
                }
                if (!QtPositioning.expectedProvidersAvailable(n2)) {
                    return 1;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 2;
            }
            return 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int startSatelliteUpdates(int n, int n2, boolean bl) {
        Object object = m_syncObject;
        synchronized (object) {
            try {
                boolean bl2 = false;
                QtPositioning qtPositioning = new QtPositioning();
                qtPositioning.isSatelliteUpdate = true;
                qtPositioning.nativeClassReference = n;
                qtPositioning.expectedProviders = 1;
                qtPositioning.isSingleUpdate = bl;
                if (n2 == 0) {
                    n2 = 50;
                }
                if (bl) {
                    Log.d((String)TAG, (String)("Single update for Satellites " + n2));
                } else {
                    Log.d((String)TAG, (String)("Regular updates for Satellites " + n2));
                }
                try {
                    QtPositioning.addActiveListener(qtPositioning, "gps", n2, 0.0f);
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                    bl2 = true;
                }
                if (bl2) {
                    QtPositioning.removeActiveListener(qtPositioning);
                    return 0;
                }
                if (!QtPositioning.expectedProvidersAvailable(qtPositioning.expectedProviders)) {
                    return 1;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return -1;
            }
            return 2;
        }
    }

    QtPositioning() {
    }

    Looper looper() {
        return this.looperThread.looper();
    }

    private void setActiveLooper(boolean bl) {
        try {
            if (bl) {
                if (this.looperThread.isAlive()) {
                    return;
                }
                if (this.isSatelliteUpdate) {
                    this.looperThread.isSatelliteListener(true);
                }
                long l = System.currentTimeMillis();
                this.looperThread.start();
                while (!this.looperThread.isReady()) {
                }
                long l2 = System.currentTimeMillis();
                Log.d((String)TAG, (String)("Looper Thread startup time in ms: " + (l2 - l)));
            } else {
                this.looperThread.quitLooper();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static native void positionUpdated(Location var0, int var1, boolean var2);

    static native void locationProvidersDisabled(int var0);

    static native void locationProvidersChanged(int var0);

    static native void satelliteGpsUpdated(Object[] var0, int var1, boolean var2);

    static native void satelliteGnssUpdated(GnssStatus var0, int var1, boolean var2);

    public void onLocationChanged(Location location) {
        if (location == null) {
            return;
        }
        if (this.useAltitudeConverter) {
            QtPositioning.addMslAltitude(location);
        }
        if (this.isSatelliteUpdate) {
            return;
        }
        if (this.isSingleUpdate || this.expectedProviders < 3) {
            QtPositioning.positionUpdated(location, this.nativeClassReference, this.isSingleUpdate);
            return;
        }
        if (location.getProvider().equals("gps")) {
            this.lastGps = location;
            QtPositioning.positionUpdated(location, this.nativeClassReference, this.isSingleUpdate);
        } else if (location.getProvider().equals("network")) {
            this.lastNetwork = location;
            if (this.lastGps == null) {
                QtPositioning.positionUpdated(location, this.nativeClassReference, this.isSingleUpdate);
                return;
            }
            long l = location.getTime() - this.lastGps.getTime();
            if (l < (long)this.updateIntervalTime) {
                return;
            }
            QtPositioning.positionUpdated(location, this.nativeClassReference, this.isSingleUpdate);
        }
    }

    public void onStatusChanged(String string, int n, Bundle bundle) {
    }

    public void onProviderEnabled(String string) {
        Log.d((String)TAG, (String)("Enabled provider: " + string));
        QtPositioning.locationProvidersChanged(this.nativeClassReference);
        if (this.isLocationProvidersDisabledInvoked && QtPositioning.expectedProvidersAvailable(this.expectedProviders)) {
            this.isLocationProvidersDisabledInvoked = false;
        }
    }

    public void onProviderDisabled(String string) {
        Log.d((String)TAG, (String)("Disabled provider: " + string));
        QtPositioning.locationProvidersChanged(this.nativeClassReference);
        if (!this.isLocationProvidersDisabledInvoked && !QtPositioning.expectedProvidersAvailable(this.expectedProviders)) {
            this.isLocationProvidersDisabledInvoked = true;
            QtPositioning.locationProvidersDisabled(this.nativeClassReference);
        }
    }

    private class PositioningLooperGps
    extends PositioningLooperBase
    implements GpsStatus.Listener {
        private PositioningLooperGps() {
        }

        @Override
        protected void addSatelliteInfoListener() {
            try {
                locationManager.addGpsStatusListener((GpsStatus.Listener)this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        protected void removeSatelliteInfoListener() {
            locationManager.removeGpsStatusListener((GpsStatus.Listener)this);
        }

        public void onGpsStatusChanged(int n) {
            switch (n) {
                case 3: {
                    break;
                }
                case 4: {
                    Object[] objectArray;
                    GpsStatus gpsStatus = locationManager.getGpsStatus(null);
                    Iterable iterable = gpsStatus.getSatellites();
                    Iterator iterator = iterable.iterator();
                    ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
                    while (iterator.hasNext()) {
                        objectArray = (Object[])iterator.next();
                        arrayList.add(objectArray);
                    }
                    objectArray = arrayList.toArray(new GpsSatellite[arrayList.size()]);
                    QtPositioning.satelliteGpsUpdated(objectArray, QtPositioning.this.nativeClassReference, QtPositioning.this.isSingleUpdate);
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    private abstract class PositioningLooperBase
    extends Thread {
        private boolean looperRunning = false;
        private Looper posLooper;
        private boolean isSatelliteLooper = false;

        protected abstract void addSatelliteInfoListener();

        protected abstract void removeSatelliteInfoListener();

        private PositioningLooperBase() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Looper.prepare();
            if (this.isSatelliteLooper) {
                this.addSatelliteInfoListener();
            }
            this.posLooper = Looper.myLooper();
            PositioningLooperBase positioningLooperBase = this;
            synchronized (positioningLooperBase) {
                this.looperRunning = true;
            }
            Looper.loop();
            positioningLooperBase = this;
            synchronized (positioningLooperBase) {
                this.looperRunning = false;
            }
        }

        void quitLooper() {
            if (this.isSatelliteLooper) {
                this.removeSatelliteInfoListener();
            }
            this.looper().quit();
        }

        synchronized boolean isReady() {
            return this.looperRunning;
        }

        void isSatelliteListener(boolean bl) {
            this.isSatelliteLooper = bl;
        }

        Looper looper() {
            return this.posLooper;
        }
    }

    private class PositioningLooperGnss
    extends PositioningLooperBase {
        private PositioningGnssListener gnssListener;

        private PositioningLooperGnss() {
            this.gnssListener = new PositioningGnssListener();
        }

        @Override
        protected void addSatelliteInfoListener() {
            try {
                locationManager.registerGnssStatusCallback((GnssStatus.Callback)this.gnssListener);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        protected void removeSatelliteInfoListener() {
            locationManager.unregisterGnssStatusCallback((GnssStatus.Callback)this.gnssListener);
        }
    }

    private class PositioningGnssListener
    extends GnssStatus.Callback {
        private PositioningGnssListener() {
        }

        public void onSatelliteStatusChanged(GnssStatus gnssStatus) {
            QtPositioning.satelliteGnssUpdated(gnssStatus, QtPositioning.this.nativeClassReference, QtPositioning.this.isSingleUpdate);
        }
    }
}

