/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.Image;
import android.media.ImageReader;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.util.Log;

public class QtScreenCaptureService
extends Service {
    private final Object mServiceStopLock = new Object();
    private boolean mServiceStopped = false;
    private static final String QtTAG = "QtScreenCaptureService";
    private static final String CHANNEL_ID = "ScreenCaptureChannel";
    private static final String VIRTUAL_DISPLAY_NAME = "ScreenCapture";
    private VirtualDisplay mVirtualDisplay = null;
    private ImageReader mImageReader = null;
    private static int MAX_FRAMES_NUMBER = 12;
    private MediaProjection mMediaProjection = null;
    private Handler mBackgroundHandler = null;
    private HandlerThread mBackgroundThread = null;
    private long mId;
    private int mScreenWidth;
    private int mScreenHeight;
    ImageReader.OnImageAvailableListener mScreenFrameListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader imageReader) {
            try {
                Image image = imageReader.acquireLatestImage();
                if (image != null) {
                    QtScreenCaptureService.onScreenFrameAvailable(image, QtScreenCaptureService.this.mId);
                } else {
                    Log.w((String)QtScreenCaptureService.QtTAG, (String)"Null frame acquired. Skip it");
                }
            }
            catch (Exception exception) {
                Log.w((String)QtScreenCaptureService.QtTAG, (String)("The frame cannot be acquired: " + exception));
            }
        }
    };
    private final IBinder binder = new ScreenCaptureBinder();

    static native void onScreenFrameAvailable(Image var0, long var1);

    static native void onErrorUpdate(String var0, long var1);

    public void onCreate() {
        super.onCreate();
        NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ID, (CharSequence)"Screen Capture", 2);
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        if (notificationManager != null) {
            notificationManager.createNotificationChannel(notificationChannel);
        }
        Notification notification = new Notification.Builder((Context)this, CHANNEL_ID).setSmallIcon(17301595).build();
        this.startForeground(1, notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int n, int n2) {
        Object object = this.mServiceStopLock;
        synchronized (object) {
            if (this.mServiceStopped) {
                return 1;
            }
            return this.onStartCommandInternal(intent, n, n2);
        }
    }

    private int onStartCommandInternal(Intent intent, int n, int n2) {
        if (this.mServiceStopped) {
            return 1;
        }
        if (intent == null) {
            return 1;
        }
        int n3 = intent.getIntExtra("resultCode", 0);
        if (n3 != -1) {
            return 1;
        }
        Intent intent2 = Build.VERSION.SDK_INT < 33 ? (Intent)intent.getParcelableExtra("data") : (Intent)intent.getParcelableExtra("data", Intent.class);
        this.mId = intent.getLongExtra("id", -1L);
        if (intent2 == null || this.mId == -1L) {
            QtScreenCaptureService.onErrorUpdate("Cannot parse Intent. Screen capture not started", this.mId);
            return 1;
        }
        this.mScreenWidth = intent.getIntExtra("width", 0);
        this.mScreenHeight = intent.getIntExtra("height", 0);
        if (this.mScreenWidth <= 0 || this.mScreenHeight <= 0) {
            QtScreenCaptureService.onErrorUpdate("Wrong Screen size. Screen capture not started", this.mId);
            return 1;
        }
        try {
            MediaProjectionManager mediaProjectionManager = (MediaProjectionManager)this.getSystemService("media_projection");
            this.mMediaProjection = mediaProjectionManager.getMediaProjection(n3, intent2);
            this.mMediaProjection.registerCallback(new MediaProjection.Callback(){

                public void onStop() {
                    QtScreenCaptureService.this.stopScreenCapture();
                    super.onStop();
                }
            }, null);
            this.startScreenCapture();
        }
        catch (IllegalStateException | SecurityException runtimeException) {
            QtScreenCaptureService.onErrorUpdate("Cannot start MediaProjection: " + runtimeException.toString(), this.mId);
        }
        return 1;
    }

    private void startScreenCapture() {
        if (this.mMediaProjection == null) {
            return;
        }
        this.mBackgroundThread = new HandlerThread("ScreenCaptureThread");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
        this.mImageReader = ImageReader.newInstance((int)this.mScreenWidth, (int)this.mScreenHeight, (int)1, (int)MAX_FRAMES_NUMBER);
        this.mVirtualDisplay = this.mMediaProjection.createVirtualDisplay(VIRTUAL_DISPLAY_NAME, this.mScreenWidth, this.mScreenHeight, 160, 1, this.mImageReader.getSurface(), null, this.mBackgroundHandler);
        this.mImageReader.setOnImageAvailableListener(this.mScreenFrameListener, this.mBackgroundHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopScreenCapture() {
        Object object = this.mServiceStopLock;
        synchronized (object) {
            if (this.mServiceStopped) {
                return;
            }
            this.mServiceStopped = true;
            if (this.mImageReader != null) {
                this.mImageReader.setOnImageAvailableListener(null, this.mBackgroundHandler);
            }
            if (this.mVirtualDisplay != null) {
                this.mVirtualDisplay.release();
                this.mVirtualDisplay = null;
            }
            if (this.mBackgroundHandler != null) {
                this.mBackgroundHandler.getLooper().quitSafely();
                this.mBackgroundHandler = null;
            }
            if (this.mBackgroundThread != null) {
                this.mBackgroundThread.quitSafely();
                try {
                    this.mBackgroundThread.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.w((String)QtTAG, (String)("The thread is interrupted. Cannot join: " + interruptedException));
                }
                this.mBackgroundThread = null;
            }
        }
    }

    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    public void onDestroy() {
        super.onDestroy();
        this.stopScreenCapture();
        if (Build.VERSION.SDK_INT < 33) {
            this.stopForeground(true);
        } else {
            this.stopForeground(1);
        }
        if (this.mMediaProjection != null) {
            this.mMediaProjection.stop();
            this.mMediaProjection = null;
        }
    }

    class ScreenCaptureBinder
    extends Binder {
        ScreenCaptureBinder() {
        }

        QtScreenCaptureService getService() {
            return QtScreenCaptureService.this;
        }
    }
}

