/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import org.qtproject.qt.android.QtQmlStatus;
import org.qtproject.qt.android.QtQmlStatusChangeListener;
import org.qtproject.qt.android.QtQuickView;
import org.qtproject.qt.android.QtSignalListener;

public abstract class QtQuickViewContent {
    private static final String TAG = "QtQuickViewContent";
    private WeakReference<QtQuickView> m_viewReference;
    private QtQmlStatusChangeListener m_statusChangeListener = null;
    private HashSet<Integer> m_signalListenerIds = new HashSet();

    public abstract String getLibraryName();

    public abstract String getModuleName();

    public abstract String getFilePath();

    public void setStatusChangeListener(QtQmlStatusChangeListener qtQmlStatusChangeListener) {
        this.m_statusChangeListener = qtQmlStatusChangeListener;
        QtQuickView qtQuickView = this.getQuickView();
        if (qtQuickView != null) {
            qtQuickView.setStatusChangeListener(qtQmlStatusChangeListener);
        }
    }

    protected QtQuickView getQuickView() {
        if (this.m_viewReference != null) {
            return (QtQuickView)((Object)this.m_viewReference.get());
        }
        return null;
    }

    protected boolean isViewAttached() {
        return this.getQuickView() != null;
    }

    protected void attachView(QtQuickView qtQuickView) {
        this.m_viewReference = new WeakReference<QtQuickView>(qtQuickView);
        if (qtQuickView != null) {
            qtQuickView.setStatusChangeListener(this.m_statusChangeListener);
        }
    }

    protected void detachView() {
        QtQuickView qtQuickView = this.getQuickView();
        if (qtQuickView != null) {
            for (int n : this.m_signalListenerIds) {
                qtQuickView.disconnectSignalListener(n);
            }
            qtQuickView.setStatusChangeListener(null);
            this.m_viewReference.clear();
            if (this.m_statusChangeListener != null) {
                this.m_statusChangeListener.onStatusChanged(QtQmlStatus.NULL);
            }
        }
    }

    protected HashMap<String, Object> attributes() {
        return new HashMap<String, Object>();
    }

    protected void setProperty(String string, Object object) {
        QtQuickView qtQuickView = this.getQuickView();
        if (qtQuickView == null) {
            Log.w((String)TAG, (String)"Cannot set property as the QQmlComponent is not loaded in a QtQuickView.");
            return;
        }
        qtQuickView.setProperty(string, object);
    }

    protected <T> T getProperty(String string) {
        QtQuickView qtQuickView = this.getQuickView();
        if (qtQuickView == null) {
            Log.w((String)TAG, (String)"Cannot get property as the QQmlComponent is not loaded in a QtQuickView.");
            return null;
        }
        return qtQuickView.getProperty(string);
    }

    protected <T> int connectSignalListener(String string, Class<T> clazz, QtSignalListener<T> qtSignalListener) {
        return this.connectSignalListener(string, new Class[]{clazz}, qtSignalListener);
    }

    protected int connectSignalListener(String string, Class<?>[] classArray, Object object) {
        QtQuickView qtQuickView = this.getQuickView();
        if (qtQuickView == null) {
            Log.w((String)TAG, (String)"Cannot connect signal listener as the QQmlComponent is not loaded in a QtQuickView.");
            return -1;
        }
        int n = qtQuickView.connectSignalListener(string, classArray, object);
        this.m_signalListenerIds.add(n);
        return n;
    }

    public boolean disconnectSignalListener(int n) {
        QtQuickView qtQuickView = this.getQuickView();
        if (qtQuickView == null) {
            Log.w((String)TAG, (String)"Cannot disconnect signal listener as the QQmlComponent is not loaded in a QtQuickView.");
            return false;
        }
        this.m_signalListenerIds.remove(n);
        return qtQuickView.disconnectSignalListener(n);
    }
}

