/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Bundle;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import java.nio.charset.StandardCharsets;
import org.qtproject.qt.android.ExtractStyle;
import org.qtproject.qt.android.QtDisplayManager;
import org.qtproject.qt.android.QtLoader;

class QtActivityLoader
extends QtLoader {
    private final Activity m_activity;

    private QtActivityLoader(Activity activity) throws IllegalArgumentException {
        super(new ContextWrapper((Context)activity));
        this.m_activity = activity;
        this.extractContextMetaData((Context)this.m_activity);
    }

    static QtActivityLoader getActivityLoader(Activity activity) throws IllegalArgumentException {
        if (m_instance == null) {
            m_instance = new QtActivityLoader(activity);
        }
        return (QtActivityLoader)m_instance;
    }

    private String getDecodedUtfString(String string2) {
        byte[] byArray = Base64.decode((String)string2, (int)0);
        return new String(byArray, StandardCharsets.UTF_8);
    }

    int getAppIconSize() {
        int n = this.m_activity.getResources().getDimensionPixelSize(0x1050000);
        if (n < 36 || n > 512) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            QtDisplayManager.getDisplay((Context)this.m_activity).getMetrics(displayMetrics);
            n = displayMetrics.densityDpi / 10 * 3;
            if (n < 36) {
                n = 36;
            }
            if (n > 512) {
                n = 512;
            }
        }
        return n;
    }

    private void setupStyleExtraction() {
        int n = this.m_activity.getResources().getDisplayMetrics().densityDpi;
        this.setEnvironmentVariable("QT_ANDROID_THEME_DISPLAY_DPI", String.valueOf(n));
        String string2 = this.getMetaData("android.app.extract_android_style");
        if (string2.equals("full")) {
            this.setEnvironmentVariable("QT_USE_ANDROID_NATIVE_STYLE", String.valueOf(1));
        }
        String string3 = ExtractStyle.setup((Context)this.m_activity, string2, n);
        this.setEnvironmentVariable("ANDROID_STYLE_PATH", string3);
    }

    @Override
    protected void extractContextMetaData(Context context) {
        boolean bl;
        super.extractContextMetaData(context);
        this.setEnvironmentVariable("QT_USE_ANDROID_NATIVE_DIALOGS", String.valueOf(1));
        this.setEnvironmentVariable("QT_ANDROID_APP_ICON_SIZE", String.valueOf(this.getAppIconSize()));
        this.setupStyleExtraction();
        Intent intent = this.m_activity.getIntent();
        if (intent == null) {
            Log.w((String)"QtLoader", (String)"Null Intent from the current Activity.");
            return;
        }
        Bundle bundle = intent.getExtras();
        if (bundle == null) {
            Log.w((String)"QtLoader", (String)"Null extras from the Activity's intent.");
            return;
        }
        int n = this.m_activity.getApplicationInfo().flags;
        boolean bl2 = bl = (n & 2) != 0;
        if (bl) {
            String string2;
            if (bundle.containsKey("extraenvvars")) {
                string2 = bundle.getString("extraenvvars");
                this.setEnvironmentVariables(this.getDecodedUtfString(string2));
            }
            if (bundle.containsKey("extraappparams")) {
                string2 = bundle.getString("extraappparams");
                this.appendApplicationParameters(this.getDecodedUtfString(string2));
            }
        } else {
            Log.d((String)"Qt JAVA", (String)"Not in debug mode! It is not allowed to use extra arguments in non-debug mode.");
        }
    }
}

