/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ClipboardManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.UsedFromNativeCode;

class QtClipboardManager {
    private static final String TAG = "QtClipboardManager";
    private ClipboardManager m_clipboardManager = null;
    private boolean m_usePrimaryClip = false;
    private final long m_nativePointer;

    static native void onClipboardDataChanged(long var0);

    QtClipboardManager(Context context, long l) {
        this.m_nativePointer = l;
        this.registerClipboardManager(context);
    }

    private void registerClipboardManager(Context context) {
        if (context != null) {
            Semaphore semaphore = new Semaphore(0);
            QtNative.runAction(() -> {
                this.m_clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
                if (this.m_clipboardManager != null) {
                    this.m_clipboardManager.addPrimaryClipChangedListener(() -> QtClipboardManager.onClipboardDataChanged(this.m_nativePointer));
                }
                semaphore.release();
            });
            try {
                semaphore.acquire();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @UsedFromNativeCode
    void clearClipData() {
        if (this.m_clipboardManager != null) {
            if (Build.VERSION.SDK_INT >= 28) {
                this.m_clipboardManager.clearPrimaryClip();
            } else {
                String[] stringArray = new String[]{"application/octet-stream"};
                ClipData clipData = new ClipData((CharSequence)"", stringArray, new ClipData.Item(new Intent()));
                this.m_clipboardManager.setPrimaryClip(clipData);
            }
        }
        this.m_usePrimaryClip = false;
    }

    @UsedFromNativeCode
    void setClipboardText(Context context, String string2) {
        if (this.m_clipboardManager != null) {
            ClipData clipData = ClipData.newPlainText((CharSequence)"text/plain", (CharSequence)string2);
            this.updatePrimaryClip(clipData, context);
        }
    }

    static boolean hasClipboardText(Context context) {
        ClipboardManager clipboardManager = (ClipboardManager)context.getSystemService("clipboard");
        if (clipboardManager == null) {
            return false;
        }
        ClipDescription clipDescription = clipboardManager.getPrimaryClipDescription();
        if (clipDescription == null) {
            return false;
        }
        for (int i = 0; i < clipDescription.getMimeTypeCount(); ++i) {
            String string2 = clipDescription.getMimeType(i);
            if (!string2.matches("text/(.*)")) continue;
            return true;
        }
        return false;
    }

    @UsedFromNativeCode
    boolean hasClipboardText() {
        return this.hasClipboardMimeType("text/(.*)");
    }

    @UsedFromNativeCode
    String getClipboardText() {
        try {
            ClipData clipData;
            if (this.m_clipboardManager != null && this.m_clipboardManager.hasPrimaryClip() && (clipData = this.m_clipboardManager.getPrimaryClip()) != null) {
                for (int i = 0; i < clipData.getItemCount(); ++i) {
                    if (clipData.getItemAt(i).getText() == null) continue;
                    return clipData.getItemAt(i).getText().toString();
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Failed to get clipboard data", (Throwable)exception);
        }
        return "";
    }

    private void updatePrimaryClip(ClipData clipData, Context context) {
        try {
            if (this.m_usePrimaryClip) {
                ClipData clipData2 = this.m_clipboardManager.getPrimaryClip();
                if (Build.VERSION.SDK_INT >= 26) {
                    Objects.requireNonNull(clipData2).addItem(context.getContentResolver(), clipData.getItemAt(0));
                } else {
                    Objects.requireNonNull(clipData2).addItem(clipData.getItemAt(0));
                }
                this.m_clipboardManager.setPrimaryClip(clipData2);
            } else {
                this.m_clipboardManager.setPrimaryClip(clipData);
                this.m_usePrimaryClip = true;
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Failed to set clipboard data", (Throwable)exception);
        }
    }

    @UsedFromNativeCode
    void setClipboardHtml(Context context, String string2, String string3) {
        if (this.m_clipboardManager != null) {
            ClipData clipData = ClipData.newHtmlText((CharSequence)"text/html", (CharSequence)string2, (String)string3);
            this.updatePrimaryClip(clipData, context);
        }
    }

    private boolean hasClipboardMimeType(String string2) {
        if (this.m_clipboardManager == null) {
            return false;
        }
        ClipDescription clipDescription = this.m_clipboardManager.getPrimaryClipDescription();
        if (clipDescription == null) {
            return false;
        }
        for (int i = 0; i < clipDescription.getMimeTypeCount(); ++i) {
            String string3 = clipDescription.getMimeType(i);
            if (!string3.matches(string2)) continue;
            return true;
        }
        return false;
    }

    @UsedFromNativeCode
    boolean hasClipboardHtml() {
        return this.hasClipboardMimeType("text/html");
    }

    @UsedFromNativeCode
    String getClipboardHtml() {
        try {
            ClipData clipData;
            if (this.m_clipboardManager != null && this.m_clipboardManager.hasPrimaryClip() && (clipData = this.m_clipboardManager.getPrimaryClip()) != null) {
                for (int i = 0; i < clipData.getItemCount(); ++i) {
                    if (clipData.getItemAt(i).getHtmlText() == null) continue;
                    return clipData.getItemAt(i).getHtmlText();
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Failed to get clipboard data", (Throwable)exception);
        }
        return "";
    }

    @UsedFromNativeCode
    void setClipboardUri(Context context, String string2) {
        if (this.m_clipboardManager != null) {
            ClipData clipData = ClipData.newUri((ContentResolver)context.getContentResolver(), (CharSequence)"text/uri-list", (Uri)Uri.parse((String)string2));
            this.updatePrimaryClip(clipData, context);
        }
    }

    @UsedFromNativeCode
    boolean hasClipboardUri() {
        return this.hasClipboardMimeType("text/uri-list");
    }

    @UsedFromNativeCode
    private String[] getClipboardUris() {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (this.m_clipboardManager != null && this.m_clipboardManager.hasPrimaryClip() && (stringArray = this.m_clipboardManager.getPrimaryClip()) != null) {
                for (int i = 0; i < stringArray.getItemCount(); ++i) {
                    if (stringArray.getItemAt(i).getUri() == null) continue;
                    arrayList.add(stringArray.getItemAt(i).getUri().toString());
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Failed to get clipboard data", (Throwable)exception);
        }
        stringArray = new String[arrayList.size()];
        stringArray = (String[])arrayList.toArray(stringArray);
        return stringArray;
    }
}

