/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

class QtBluetoothLE {
    private static final String TAG = "QtBluetoothGatt";
    private BluetoothAdapter mBluetoothAdapter = null;
    private boolean mLeScanRunning = false;
    private BluetoothGatt mBluetoothGatt = null;
    private HandlerThread mHandlerThread = null;
    private Handler mHandler = null;
    private Constructor<BluetoothGattCharacteristic> mCharacteristicConstructor = null;
    private String mRemoteGattAddress;
    private final UUID clientCharacteristicUuid = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private final int MAX_MTU = 512;
    private final int DEFAULT_MTU = 23;
    private int mSupportedMtu = -1;
    private int HANDLE_FOR_RESET = -1;
    private int HANDLE_FOR_MTU_EXCHANGE = -2;
    private int HANDLE_FOR_RSSI_READ = -3;
    private AtomicInteger handleForTimeout = new AtomicInteger(this.HANDLE_FOR_RESET);
    private final int RUNNABLE_TIMEOUT = 3000;
    private final Handler timeoutHandler = new Handler(Looper.getMainLooper());
    private BluetoothLeScanner mBluetoothLeScanner = null;
    private BroadcastReceiver bondStateBroadcastReceiver = null;
    long qtObject = 0L;
    Context qtContext = null;
    private final ScanCallback leScanCallback = new ScanCallback(){

        public void onScanResult(int n, ScanResult scanResult) {
            super.onScanResult(n, scanResult);
            QtBluetoothLE.this.leScanResult(QtBluetoothLE.this.qtObject, scanResult.getDevice(), scanResult.getRssi(), scanResult.getScanRecord().getBytes());
        }

        public void onBatchScanResults(List<ScanResult> list) {
            super.onBatchScanResults(list);
            for (ScanResult scanResult : list) {
                QtBluetoothLE.this.leScanResult(QtBluetoothLE.this.qtObject, scanResult.getDevice(), scanResult.getRssi(), scanResult.getScanRecord().getBytes());
            }
        }

        public void onScanFailed(int n) {
            super.onScanFailed(n);
            Log.d((String)QtBluetoothLE.TAG, (String)("BTLE device scan failed with " + n));
        }
    };
    private final BluetoothGattCallback gattCallback = new BluetoothGattCallback(){

        public void onConnectionStateChange(BluetoothGatt bluetoothGatt, int n, int n2) {
            super.onConnectionStateChange(bluetoothGatt, n, n2);
            QtBluetoothLE.this.handleOnConnectionStateChange(bluetoothGatt, n, n2);
        }

        public void onServicesDiscovered(BluetoothGatt bluetoothGatt, int n) {
            super.onServicesDiscovered(bluetoothGatt, n);
            QtBluetoothLE.this.handleOnServicesDiscovered(bluetoothGatt, n);
        }

        public void onCharacteristicRead(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            super.onCharacteristicRead(bluetoothGatt, bluetoothGattCharacteristic, n);
            QtBluetoothLE.this.handleOnCharacteristicRead(bluetoothGatt, bluetoothGattCharacteristic, bluetoothGattCharacteristic.getValue(), n);
        }

        public void onCharacteristicRead(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, byte[] byArray, int n) {
            QtBluetoothLE.this.handleOnCharacteristicRead(bluetoothGatt, bluetoothGattCharacteristic, byArray, n);
        }

        public void onCharacteristicWrite(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
            super.onCharacteristicWrite(bluetoothGatt, bluetoothGattCharacteristic, n);
            QtBluetoothLE.this.handleOnCharacteristicWrite(bluetoothGatt, bluetoothGattCharacteristic, n);
        }

        public void onCharacteristicChanged(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
            super.onCharacteristicChanged(bluetoothGatt, bluetoothGattCharacteristic);
            QtBluetoothLE.this.handleOnCharacteristicChanged(bluetoothGatt, bluetoothGattCharacteristic, bluetoothGattCharacteristic.getValue());
        }

        public void onCharacteristicChanged(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, byte[] byArray) {
            QtBluetoothLE.this.handleOnCharacteristicChanged(bluetoothGatt, bluetoothGattCharacteristic, byArray);
        }

        public void onDescriptorRead(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
            super.onDescriptorRead(bluetoothGatt, bluetoothGattDescriptor, n);
            QtBluetoothLE.this.handleOnDescriptorRead(bluetoothGatt, bluetoothGattDescriptor, n, bluetoothGattDescriptor.getValue());
        }

        public void onDescriptorRead(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n, byte[] byArray) {
            QtBluetoothLE.this.handleOnDescriptorRead(bluetoothGatt, bluetoothGattDescriptor, n, byArray);
        }

        public void onDescriptorWrite(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
            super.onDescriptorWrite(bluetoothGatt, bluetoothGattDescriptor, n);
            QtBluetoothLE.this.handleOnDescriptorWrite(bluetoothGatt, bluetoothGattDescriptor, n);
        }

        public void onReadRemoteRssi(BluetoothGatt bluetoothGatt, int n, int n2) {
            super.onReadRemoteRssi(bluetoothGatt, n, n2);
            QtBluetoothLE.this.handleOnReadRemoteRssi(bluetoothGatt, n, n2);
        }

        public void onMtuChanged(BluetoothGatt bluetoothGatt, int n, int n2) {
            super.onMtuChanged(bluetoothGatt, n, n2);
            QtBluetoothLE.this.handleOnMtuChanged(bluetoothGatt, n, n2);
        }
    };
    private final Hashtable<UUID, List<Integer>> uuidToEntry = new Hashtable(100);
    private final ArrayList<GattEntry> entries = new ArrayList(100);
    private final LinkedList<Integer> servicesToBeDiscovered = new LinkedList();
    private final LinkedList<ReadWriteJob> readWriteQueue = new LinkedList();
    private ReadWriteJob pendingJob;

    private synchronized void handleOnReceive(Context context, Intent intent) {
        if (this.mBluetoothGatt == null) {
            return;
        }
        BluetoothDevice bluetoothDevice = QtBluetoothLE.getDevice(intent);
        if (bluetoothDevice == null || !bluetoothDevice.getAddress().equals(this.mBluetoothGatt.getDevice().getAddress())) {
            return;
        }
        int n = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
        int n2 = intent.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", -1);
        if (n == 11) {
            if (this.pendingJob == null || this.pendingJob.jobType == IoJobType.Mtu || this.pendingJob.jobType == IoJobType.Rssi) {
                return;
            }
            this.timeoutHandler.removeCallbacksAndMessages(null);
            this.handleForTimeout.set(this.HANDLE_FOR_RESET);
        } else if (n2 == 11 && (n == 12 || n == 10)) {
            if (this.pendingJob == null || this.pendingJob.jobType == IoJobType.Mtu || this.pendingJob.jobType == IoJobType.Rssi) {
                return;
            }
            this.readWriteQueue.addFirst(this.pendingJob);
            this.pendingJob = null;
            this.performNextIO();
        } else if (n2 == 12 && n == 10) {
            try {
                bluetoothDevice.getClass().getMethod("removeBond", new Class[0]).invoke((Object)bluetoothDevice, new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static BluetoothDevice getDevice(Intent intent) {
        if (Build.VERSION.SDK_INT >= 33) {
            return (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE", BluetoothDevice.class);
        }
        return (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
    }

    QtBluetoothLE(Context context) {
        this.qtContext = context;
        BluetoothManager bluetoothManager = (BluetoothManager)this.qtContext.getSystemService("bluetooth");
        if (bluetoothManager == null) {
            return;
        }
        this.mBluetoothAdapter = bluetoothManager.getAdapter();
        if (this.mBluetoothAdapter == null) {
            return;
        }
        this.mBluetoothLeScanner = this.mBluetoothAdapter.getBluetoothLeScanner();
    }

    QtBluetoothLE(String string, Context context) {
        this(context);
        this.mRemoteGattAddress = string;
    }

    boolean scanForLeDevice(boolean bl) {
        if (bl == this.mLeScanRunning) {
            return true;
        }
        if (this.mBluetoothLeScanner == null) {
            Log.w((String)TAG, (String)"Cannot start LE scan, no bluetooth scanner");
            return false;
        }
        if (bl) {
            Log.d((String)TAG, (String)"Attempting to start BTLE scan");
            ScanSettings.Builder builder = new ScanSettings.Builder();
            builder = builder.setScanMode(1);
            ScanSettings scanSettings = builder.build();
            ArrayList arrayList = new ArrayList();
            this.mBluetoothLeScanner.startScan(arrayList, scanSettings, this.leScanCallback);
            this.mLeScanRunning = true;
        } else {
            Log.d((String)TAG, (String)"Attempting to stop BTLE scan");
            try {
                this.mBluetoothLeScanner.stopScan(this.leScanCallback);
            }
            catch (IllegalStateException illegalStateException) {
                Log.d((String)TAG, (String)("Stopping LE scan not possible: " + illegalStateException.getMessage()));
            }
            this.mLeScanRunning = false;
        }
        return this.mLeScanRunning == bl;
    }

    native void leScanResult(long var1, BluetoothDevice var3, int var4, byte[] var5);

    private synchronized void handleOnConnectionStateChange(BluetoothGatt bluetoothGatt, int n, int n2) {
        int n3;
        Log.d((String)TAG, (String)("Connection state changes to: " + n2 + ", status: " + n + ", qtObject: " + (this.qtObject != 0L)));
        if (this.qtObject == 0L) {
            return;
        }
        int n4 = 0;
        switch (n2) {
            case 0: {
                if (this.bondStateBroadcastReceiver != null) {
                    this.qtContext.unregisterReceiver(this.bondStateBroadcastReceiver);
                    this.bondStateBroadcastReceiver = null;
                }
                n4 = 0;
                this.resetData();
                if (this.mBluetoothGatt != null) {
                    this.mBluetoothGatt.close();
                    if (this.mHandler != null) {
                        this.mHandler.getLooper().quitSafely();
                        this.mHandler = null;
                    }
                }
                this.mBluetoothGatt = null;
                break;
            }
            case 2: {
                if (this.bondStateBroadcastReceiver == null) {
                    this.bondStateBroadcastReceiver = new BondStateBroadcastReceiver();
                    this.qtContext.registerReceiver(this.bondStateBroadcastReceiver, new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED"));
                }
                n4 = 2;
            }
        }
        switch (n) {
            case 0: {
                n3 = 0;
                break;
            }
            case 257: {
                n3 = 1;
                break;
            }
            case 8: {
                Log.w((String)TAG, (String)"Connection Error: Try to delay connect() call after previous activity");
                n3 = 5;
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                Log.w((String)TAG, (String)"The remote host closed the connection");
                n3 = 7;
                break;
            }
            case 22: {
                n3 = 8;
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Unhandled error code on connectionStateChanged: " + n + " " + n2));
                n3 = n;
            }
        }
        this.leConnectionStateChange(this.qtObject, n3, n4);
    }

    private synchronized void handleOnServicesDiscovered(BluetoothGatt bluetoothGatt, int n) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        switch (n) {
            case 0: {
                n2 = 0;
                List list = this.mBluetoothGatt.getServices();
                for (BluetoothGattService bluetoothGattService : list) {
                    stringBuilder.append(bluetoothGattService.getUuid().toString()).append(" ");
                }
                break;
            }
            default: {
                Log.w((String)TAG, (String)("Unhandled error code on onServicesDiscovered: " + n));
                n2 = n;
            }
        }
        this.leServicesDiscovered(this.qtObject, n2, stringBuilder.toString());
        if (n == 0) {
            this.scheduleMtuExchange();
        }
    }

    private synchronized void handleOnCharacteristicRead(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, byte[] byArray, int n) {
        boolean bl;
        int n2 = this.handleForCharacteristic(bluetoothGattCharacteristic);
        if (n2 == -1 || n2 >= this.entries.size()) {
            Log.w((String)TAG, (String)("Cannot find characteristic read request for read notification - handle: " + n2 + " size: " + this.entries.size()));
            this.pendingJob = null;
            this.performNextIO();
            return;
        }
        boolean bl2 = bl = !this.handleForTimeout.compareAndSet(this.modifiedReadWriteHandle(n2, IoJobType.Read), this.HANDLE_FOR_RESET);
        if (bl) {
            Log.w((String)TAG, (String)("Late char read reply after timeout was hit for handle " + n2));
            return;
        }
        GattEntry gattEntry = this.entries.get(n2);
        boolean bl3 = !gattEntry.valueKnown;
        gattEntry.valueKnown = true;
        if (n == 0) {
            this.leCharacteristicRead(this.qtObject, bluetoothGattCharacteristic.getService().getUuid().toString(), n2 + 1, bluetoothGattCharacteristic.getUuid().toString(), bluetoothGattCharacteristic.getProperties(), byArray);
        } else if (bl3) {
            Log.w((String)TAG, (String)("onCharacteristicRead during discovery error: " + n));
            Log.d((String)TAG, (String)("Non-readable characteristic " + bluetoothGattCharacteristic.getUuid() + " for service " + bluetoothGattCharacteristic.getService().getUuid()));
            this.leCharacteristicRead(this.qtObject, bluetoothGattCharacteristic.getService().getUuid().toString(), n2 + 1, bluetoothGattCharacteristic.getUuid().toString(), bluetoothGattCharacteristic.getProperties(), byArray);
        } else {
            this.leServiceError(this.qtObject, n2 + 1, 5);
        }
        if (bl3) {
            GattEntry gattEntry2 = this.entries.get(gattEntry.associatedServiceHandle);
            if (gattEntry2.endHandle == n2) {
                this.finishCurrentServiceDiscovery(gattEntry.associatedServiceHandle);
            }
        }
        this.pendingJob = null;
        this.performNextIO();
    }

    private synchronized void handleOnCharacteristicChanged(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, byte[] byArray) {
        int n = this.handleForCharacteristic(bluetoothGattCharacteristic);
        if (n == -1) {
            Log.w((String)TAG, (String)"onCharacteristicChanged: cannot find handle");
            return;
        }
        this.leCharacteristicChanged(this.qtObject, n + 1, byArray);
    }

    private synchronized void handleOnCharacteristicWrite(BluetoothGatt bluetoothGatt, BluetoothGattCharacteristic bluetoothGattCharacteristic, int n) {
        int n2;
        boolean bl;
        int n3;
        if (n != 0) {
            Log.w((String)TAG, (String)("onCharacteristicWrite: error " + n));
        }
        if ((n3 = this.handleForCharacteristic(bluetoothGattCharacteristic)) == -1) {
            Log.w((String)TAG, (String)"onCharacteristicWrite: cannot find handle");
            return;
        }
        boolean bl2 = bl = !this.handleForTimeout.compareAndSet(this.modifiedReadWriteHandle(n3, IoJobType.Write), this.HANDLE_FOR_RESET);
        if (bl) {
            Log.w((String)TAG, (String)("Late char write reply after timeout was hit for handle " + n3));
            return;
        }
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        byte[] byArray = this.pendingJob.newValue;
        this.pendingJob = null;
        this.leCharacteristicWritten(this.qtObject, n3 + 1, byArray, n2);
        this.performNextIO();
    }

    private synchronized void handleOnDescriptorRead(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n, byte[] byArray) {
        boolean bl;
        int n2 = this.handleForDescriptor(bluetoothGattDescriptor);
        if (n2 == -1 || n2 >= this.entries.size()) {
            Log.w((String)TAG, (String)("Cannot find descriptor read request for read notification - handle: " + n2 + " size: " + this.entries.size()));
            this.pendingJob = null;
            this.performNextIO();
            return;
        }
        boolean bl2 = bl = !this.handleForTimeout.compareAndSet(this.modifiedReadWriteHandle(n2, IoJobType.Read), this.HANDLE_FOR_RESET);
        if (bl) {
            Log.w((String)TAG, (String)("Late descriptor read reply after timeout was hit for handle " + n2));
            return;
        }
        GattEntry gattEntry = this.entries.get(n2);
        boolean bl3 = !gattEntry.valueKnown;
        gattEntry.valueKnown = true;
        if (n == 0) {
            this.leDescriptorRead(this.qtObject, bluetoothGattDescriptor.getCharacteristic().getService().getUuid().toString(), bluetoothGattDescriptor.getCharacteristic().getUuid().toString(), n2 + 1, bluetoothGattDescriptor.getUuid().toString(), byArray);
        } else if (bl3) {
            Log.w((String)TAG, (String)("onDescriptorRead during discovery error: " + n));
            Log.d((String)TAG, (String)("Non-readable descriptor " + bluetoothGattDescriptor.getUuid() + " for characteristic " + bluetoothGattDescriptor.getCharacteristic().getUuid() + " for service " + bluetoothGattDescriptor.getCharacteristic().getService().getUuid()));
            this.leDescriptorRead(this.qtObject, bluetoothGattDescriptor.getCharacteristic().getService().getUuid().toString(), bluetoothGattDescriptor.getCharacteristic().getUuid().toString(), n2 + 1, bluetoothGattDescriptor.getUuid().toString(), byArray);
        } else {
            this.leServiceError(this.qtObject, n2 + 1, 6);
        }
        if (bl3) {
            GattEntry gattEntry2 = this.entries.get(gattEntry.associatedServiceHandle);
            if (gattEntry2.endHandle == n2) {
                this.finishCurrentServiceDiscovery(gattEntry.associatedServiceHandle);
            }
            if (bluetoothGattDescriptor.getUuid().compareTo(this.clientCharacteristicUuid) == 0) {
                int n3;
                byte[] byArray2 = byArray;
                int n4 = n3 = byArray2 != null && byArray2.length > 0 ? byArray2[0] : 0;
                if ((n3 & 3) > 0) {
                    Log.d((String)TAG, (String)"Found descriptor with automatic notifications.");
                    this.mBluetoothGatt.setCharacteristicNotification(bluetoothGattDescriptor.getCharacteristic(), true);
                }
            }
        }
        this.pendingJob = null;
        this.performNextIO();
    }

    private synchronized void handleOnDescriptorWrite(BluetoothGatt bluetoothGatt, BluetoothGattDescriptor bluetoothGattDescriptor, int n) {
        int n2;
        int n3;
        boolean bl;
        if (n != 0) {
            Log.w((String)TAG, (String)("onDescriptorWrite: error " + n));
        }
        boolean bl2 = bl = !this.handleForTimeout.compareAndSet(this.modifiedReadWriteHandle(n3 = this.handleForDescriptor(bluetoothGattDescriptor), IoJobType.Write), this.HANDLE_FOR_RESET);
        if (bl) {
            Log.w((String)TAG, (String)("Late descriptor write reply after timeout was hit for handle " + n3));
            return;
        }
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            default: {
                n2 = 3;
            }
        }
        byte[] byArray = this.pendingJob.newValue;
        this.pendingJob = null;
        this.leDescriptorWritten(this.qtObject, n3 + 1, byArray, n2);
        this.performNextIO();
    }

    private synchronized void handleOnMtuChanged(BluetoothGatt bluetoothGatt, int n, int n2) {
        boolean bl;
        int n3 = this.mSupportedMtu;
        if (n2 == 0) {
            Log.w((String)TAG, (String)("MTU changed to " + n));
            this.mSupportedMtu = n;
        } else {
            Log.w((String)TAG, (String)("MTU change error " + n2 + ". New MTU " + n));
            this.mSupportedMtu = 23;
        }
        if (n3 != this.mSupportedMtu) {
            this.leMtuChanged(this.qtObject, this.mSupportedMtu);
        }
        boolean bl2 = bl = !this.handleForTimeout.compareAndSet(this.modifiedReadWriteHandle(this.HANDLE_FOR_MTU_EXCHANGE, IoJobType.Mtu), this.HANDLE_FOR_RESET);
        if (bl) {
            Log.w((String)TAG, (String)"Late mtu reply after timeout was hit");
            return;
        }
        this.pendingJob = null;
        this.performNextIO();
    }

    private synchronized void handleOnReadRemoteRssi(BluetoothGatt bluetoothGatt, int n, int n2) {
        boolean bl;
        Log.d((String)TAG, (String)("RSSI read callback, rssi: " + n + ", status: " + n2));
        this.leRemoteRssiRead(this.qtObject, n, n2 == 0);
        boolean bl2 = bl = !this.handleForTimeout.compareAndSet(this.modifiedReadWriteHandle(this.HANDLE_FOR_RSSI_READ, IoJobType.Rssi), this.HANDLE_FOR_RESET);
        if (bl) {
            Log.w((String)TAG, (String)"Late RSSI read reply after timeout was hit");
            return;
        }
        this.pendingJob = null;
        this.performNextIO();
    }

    synchronized int mtu() {
        if (this.mSupportedMtu == -1) {
            return 23;
        }
        return this.mSupportedMtu;
    }

    synchronized boolean readRemoteRssi() {
        if (this.mBluetoothGatt == null) {
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.jobType = IoJobType.Rssi;
        readWriteJob.entry = null;
        if (!this.readWriteQueue.add(readWriteJob)) {
            Log.w((String)TAG, (String)"Cannot add remote RSSI read to queue");
            return false;
        }
        this.performNextIOThreaded();
        return true;
    }

    synchronized boolean connect() {
        Class[] classArray;
        BluetoothDevice bluetoothDevice;
        if (this.mBluetoothAdapter == null) {
            Log.w((String)TAG, (String)"Cannot connect, no bluetooth adapter");
            return false;
        }
        try {
            bluetoothDevice = this.mBluetoothAdapter.getRemoteDevice(this.mRemoteGattAddress);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w((String)TAG, (String)("Remote address is not valid: " + this.mRemoteGattAddress));
            return false;
        }
        if (Build.VERSION.SDK_INT >= 27) {
            classArray = new HandlerThread("QtBluetoothLEHandlerThread");
            classArray.start();
            this.mHandler = new Handler(classArray.getLooper());
            Class[] classArray2 = new Class[]{Context.class, Boolean.TYPE, BluetoothGattCallback.class, Integer.TYPE, Integer.TYPE, Handler.class};
            try {
                Method method = bluetoothDevice.getClass().getDeclaredMethod("connectGatt", classArray2);
                if (method != null) {
                    this.mBluetoothGatt = (BluetoothGatt)method.invoke((Object)bluetoothDevice, this.qtContext, false, this.gattCallback, 2, 1, this.mHandler);
                    Log.w((String)TAG, (String)"Using Android v26 BluetoothDevice.connectGatt()");
                }
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"connectGatt() v26 not available");
                exception.printStackTrace();
            }
            if (this.mBluetoothGatt == null) {
                this.mHandler.getLooper().quitSafely();
                this.mHandler = null;
            }
        }
        if (this.mBluetoothGatt == null) {
            try {
                classArray = new Class[]{BluetoothGattService.class, UUID.class, Integer.TYPE, Integer.TYPE, Integer.TYPE};
                this.mCharacteristicConstructor = BluetoothGattCharacteristic.class.getDeclaredConstructor(classArray);
                this.mCharacteristicConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.w((String)TAG, (String)"Unable get characteristic constructor. Buffer race condition are possible");
            }
            try {
                this.mBluetoothGatt = bluetoothDevice.connectGatt(this.qtContext, false, this.gattCallback, 2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)TAG, (String)"Gatt connection failed");
                illegalArgumentException.printStackTrace();
            }
        }
        return this.mBluetoothGatt != null;
    }

    synchronized void disconnect() {
        if (this.mBluetoothGatt == null) {
            return;
        }
        this.mBluetoothGatt.disconnect();
    }

    synchronized boolean discoverServices() {
        return this.mBluetoothGatt != null && this.mBluetoothGatt.discoverServices();
    }

    private int handleForCharacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        if (bluetoothGattCharacteristic == null) {
            return -1;
        }
        List<Integer> list = this.uuidToEntry.get(bluetoothGattCharacteristic.getService().getUuid());
        if (list == null || list.isEmpty()) {
            return -1;
        }
        int n = list.get(0);
        try {
            block7: for (int i = n + 1; i < this.entries.size(); ++i) {
                GattEntry gattEntry = this.entries.get(i);
                if (gattEntry == null) continue;
                switch (gattEntry.type) {
                    case Descriptor: 
                    case CharacteristicValue: {
                        continue block7;
                    }
                    case Service: {
                        continue block7;
                    }
                    case Characteristic: {
                        if (gattEntry.characteristic != bluetoothGattCharacteristic) continue block7;
                        return i;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    private int handleForDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor) {
        if (bluetoothGattDescriptor == null) {
            return -1;
        }
        List<Integer> list = this.uuidToEntry.get(bluetoothGattDescriptor.getCharacteristic().getService().getUuid());
        if (list == null || list.isEmpty()) {
            return -1;
        }
        int n = list.get(0);
        try {
            block7: for (int i = n + 1; i < this.entries.size(); ++i) {
                GattEntry gattEntry = this.entries.get(i);
                if (gattEntry == null) continue;
                switch (gattEntry.type) {
                    case CharacteristicValue: 
                    case Characteristic: {
                        continue block7;
                    }
                    case Service: {
                        continue block7;
                    }
                    case Descriptor: {
                        if (gattEntry.descriptor != bluetoothGattDescriptor) continue block7;
                        return i;
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    private void populateHandles() {
        GattEntry gattEntry = null;
        List list = this.mBluetoothGatt.getServices();
        for (BluetoothGattService bluetoothGattService : list) {
            int n;
            GattEntry gattEntry2 = new GattEntry();
            gattEntry2.type = GattEntryType.Service;
            gattEntry2.service = bluetoothGattService;
            this.entries.add(gattEntry2);
            gattEntry2.associatedServiceHandle = n = this.entries.size() - 1;
            List<Integer> list2 = this.uuidToEntry.get(bluetoothGattService.getUuid());
            if (list2 == null) {
                list2 = new ArrayList<Integer>();
            }
            list2.add(this.entries.size() - 1);
            this.uuidToEntry.put(bluetoothGattService.getUuid(), list2);
            List list3 = bluetoothGattService.getCharacteristics();
            for (BluetoothGattCharacteristic bluetoothGattCharacteristic : list3) {
                gattEntry = new GattEntry();
                gattEntry.type = GattEntryType.Characteristic;
                gattEntry.characteristic = bluetoothGattCharacteristic;
                gattEntry.associatedServiceHandle = n;
                this.entries.add(gattEntry);
                gattEntry = new GattEntry();
                gattEntry.type = GattEntryType.CharacteristicValue;
                gattEntry.associatedServiceHandle = n;
                gattEntry.endHandle = this.entries.size();
                this.entries.add(gattEntry);
                List list4 = bluetoothGattCharacteristic.getDescriptors();
                for (BluetoothGattDescriptor bluetoothGattDescriptor : list4) {
                    gattEntry = new GattEntry();
                    gattEntry.type = GattEntryType.Descriptor;
                    gattEntry.descriptor = bluetoothGattDescriptor;
                    gattEntry.associatedServiceHandle = n;
                    this.entries.add(gattEntry);
                }
            }
            gattEntry2.endHandle = this.entries.size() - 1;
        }
        this.entries.trimToSize();
    }

    private void resetData() {
        this.uuidToEntry.clear();
        this.entries.clear();
        this.servicesToBeDiscovered.clear();
        this.timeoutHandler.removeCallbacksAndMessages(null);
        this.handleForTimeout.set(this.HANDLE_FOR_RESET);
        this.readWriteQueue.clear();
        this.pendingJob = null;
    }

    synchronized boolean discoverServiceDetails(String string, boolean bl) {
        Log.d((String)TAG, (String)("Discover service details for: " + string + ", fullDiscovery: " + bl + ", BluetoothGatt: " + (this.mBluetoothGatt != null)));
        try {
            GattEntry gattEntry;
            int n;
            if (this.mBluetoothGatt == null) {
                return false;
            }
            if (this.entries.isEmpty()) {
                this.populateHandles();
            }
            try {
                UUID uUID = UUID.fromString(string);
                List<Integer> list = this.uuidToEntry.get(uUID);
                if (list == null || list.isEmpty()) {
                    Log.w((String)TAG, (String)("Unknown service uuid for current device: " + uUID.toString()));
                    return false;
                }
                n = list.get(0);
                gattEntry = this.entries.get(n);
                if (gattEntry == null) {
                    Log.w((String)TAG, (String)("Service with UUID " + uUID.toString() + " not found"));
                    return false;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.w((String)TAG, (String)"Cannot parse given UUID");
                return false;
            }
            if (gattEntry.type != GattEntryType.Service) {
                Log.w((String)TAG, (String)("Given UUID is not a service UUID: " + string));
                return false;
            }
            if (gattEntry.valueKnown || this.servicesToBeDiscovered.contains(n)) {
                Log.w((String)TAG, (String)"Service already known or to be discovered");
                return true;
            }
            this.servicesToBeDiscovered.add(n);
            this.scheduleServiceDetailDiscovery(n, bl);
            this.performNextIOThreaded();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    synchronized String includedServices(String string) {
        UUID uUID;
        if (this.mBluetoothGatt == null) {
            return null;
        }
        try {
            uUID = UUID.fromString(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        BluetoothGattService bluetoothGattService = this.mBluetoothGatt.getService(uUID);
        if (bluetoothGattService == null) {
            return null;
        }
        List list = bluetoothGattService.getIncludedServices();
        if (list.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (BluetoothGattService bluetoothGattService2 : list) {
            stringBuilder.append(bluetoothGattService2.getUuid().toString()).append(" ");
        }
        return stringBuilder.toString();
    }

    private synchronized void finishCurrentServiceDiscovery(int n) {
        Log.w((String)TAG, (String)("Finished current discovery for service handle " + n));
        GattEntry gattEntry = this.entries.get(n);
        gattEntry.valueKnown = true;
        try {
            this.servicesToBeDiscovered.removeFirst();
        }
        catch (NoSuchElementException noSuchElementException) {
            Log.w((String)TAG, (String)"Expected queued service but didn't find any");
        }
        this.leServiceDetailDiscoveryFinished(this.qtObject, gattEntry.service.getUuid().toString(), n + 1, gattEntry.endHandle + 1);
    }

    private boolean executeMtuExchange() {
        if (this.mBluetoothGatt.requestMtu(512)) {
            Log.w((String)TAG, (String)"MTU change initiated");
            return false;
        }
        Log.w((String)TAG, (String)"MTU change request failed");
        Log.w((String)TAG, (String)"Assuming default MTU value of 23 bytes");
        this.mSupportedMtu = 23;
        return true;
    }

    private boolean executeRemoteRssiRead() {
        if (this.mBluetoothGatt.readRemoteRssi()) {
            Log.d((String)TAG, (String)"RSSI read initiated");
            return false;
        }
        Log.w((String)TAG, (String)"Initiating remote RSSI read failed");
        this.leRemoteRssiRead(this.qtObject, 0, false);
        return true;
    }

    private void scheduleMtuExchange() {
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.jobType = IoJobType.Mtu;
        readWriteJob.entry = null;
        this.readWriteQueue.add(readWriteJob);
        this.performNextIO();
    }

    private void scheduleServiceDetailDiscovery(int n, boolean bl) {
        GattEntry gattEntry = this.entries.get(n);
        int n2 = gattEntry.endHandle;
        if (n == n2) {
            Log.w((String)TAG, (String)"scheduleServiceDetailDiscovery: service is empty; nothing to discover");
            this.finishCurrentServiceDiscovery(n);
            return;
        }
        for (int i = n + 1; i <= n2; ++i) {
            GattEntry gattEntry2 = this.entries.get(i);
            if (gattEntry2.type == GattEntryType.Service) {
                Log.w((String)TAG, (String)"scheduleServiceDetailDiscovery: wrong endHandle");
                return;
            }
            ReadWriteJob readWriteJob = new ReadWriteJob();
            readWriteJob.entry = gattEntry2;
            readWriteJob.jobType = bl ? IoJobType.Read : IoJobType.SkippedRead;
            boolean bl2 = this.readWriteQueue.add(readWriteJob);
            if (bl2) continue;
            Log.w((String)TAG, (String)("Cannot add service discovery job for " + gattEntry.service.getUuid() + " on item " + (Object)((Object)gattEntry2.type)));
        }
    }

    synchronized boolean writeCharacteristic(int n, byte[] byArray, int n2) {
        GattEntry gattEntry;
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            gattEntry = this.entries.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.newValue = byArray;
        readWriteJob.entry = gattEntry;
        readWriteJob.jobType = IoJobType.Write;
        switch (n2) {
            case 1: {
                readWriteJob.requestedWriteType = 1;
                break;
            }
            case 2: {
                readWriteJob.requestedWriteType = 4;
                break;
            }
            default: {
                readWriteJob.requestedWriteType = 2;
            }
        }
        boolean bl = this.readWriteQueue.add(readWriteJob);
        if (!bl) {
            Log.w((String)TAG, (String)("Cannot add characteristic write request for " + n + " to queue"));
            return false;
        }
        this.performNextIOThreaded();
        return true;
    }

    synchronized boolean writeDescriptor(int n, byte[] byArray) {
        GattEntry gattEntry;
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            gattEntry = this.entries.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.newValue = byArray;
        readWriteJob.entry = gattEntry;
        readWriteJob.requestedWriteType = 2;
        readWriteJob.jobType = IoJobType.Write;
        boolean bl = this.readWriteQueue.add(readWriteJob);
        if (!bl) {
            Log.w((String)TAG, (String)("Cannot add descriptor write request for " + n + " to queue"));
            return false;
        }
        this.performNextIOThreaded();
        return true;
    }

    synchronized boolean readCharacteristic(int n) {
        GattEntry gattEntry;
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            gattEntry = this.entries.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.entry = gattEntry;
        readWriteJob.jobType = IoJobType.Read;
        boolean bl = this.readWriteQueue.add(readWriteJob);
        if (!bl) {
            Log.w((String)TAG, (String)("Cannot add characteristic read request for " + n + " to queue"));
            return false;
        }
        this.performNextIOThreaded();
        return true;
    }

    synchronized boolean readDescriptor(int n) {
        GattEntry gattEntry;
        if (this.mBluetoothGatt == null) {
            return false;
        }
        try {
            gattEntry = this.entries.get(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
            return false;
        }
        ReadWriteJob readWriteJob = new ReadWriteJob();
        readWriteJob.entry = gattEntry;
        readWriteJob.jobType = IoJobType.Read;
        boolean bl = this.readWriteQueue.add(readWriteJob);
        if (!bl) {
            Log.w((String)TAG, (String)("Cannot add descriptor read request for " + n + " to queue"));
            return false;
        }
        this.performNextIOThreaded();
        return true;
    }

    private synchronized void interruptCurrentIO(int n) {
        this.pendingJob = null;
        this.performNextIOThreaded();
        if (n == this.HANDLE_FOR_MTU_EXCHANGE || n == this.HANDLE_FOR_RSSI_READ) {
            return;
        }
        try {
            GattEntry gattEntry = this.entries.get(n);
            if (gattEntry == null) {
                return;
            }
            if (gattEntry.valueKnown) {
                return;
            }
            gattEntry.valueKnown = true;
            GattEntry gattEntry2 = this.entries.get(gattEntry.associatedServiceHandle);
            if (gattEntry2 != null && gattEntry2.endHandle == n) {
                this.finishCurrentServiceDiscovery(gattEntry.associatedServiceHandle);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Log.w((String)TAG, (String)("interruptCurrentIO(): Unknown gatt entry, index: " + n + " size: " + this.entries.size()));
        }
    }

    private void performNextIOThreaded() {
        if (this.mHandler != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    QtBluetoothLE.this.performNextIO();
                }
            });
        } else {
            this.performNextIO();
        }
    }

    private synchronized void performNextIO() {
        Log.d((String)TAG, (String)("Perform next BTLE IO, job queue size: " + this.readWriteQueue.size() + ", a job is pending: " + (this.pendingJob != null) + ", BluetoothGatt: " + (this.mBluetoothGatt != null)));
        if (this.mBluetoothGatt == null) {
            return;
        }
        boolean bl = false;
        int n = this.HANDLE_FOR_RESET;
        if (this.readWriteQueue.isEmpty() || this.pendingJob != null) {
            return;
        }
        ReadWriteJob readWriteJob = this.readWriteQueue.remove();
        if (readWriteJob.jobType == IoJobType.Mtu) {
            n = this.HANDLE_FOR_MTU_EXCHANGE;
        } else if (readWriteJob.jobType == IoJobType.Rssi) {
            n = this.HANDLE_FOR_RSSI_READ;
        } else {
            switch (readWriteJob.entry.type) {
                case Characteristic: {
                    n = this.handleForCharacteristic(readWriteJob.entry.characteristic);
                    break;
                }
                case Descriptor: {
                    n = this.handleForDescriptor(readWriteJob.entry.descriptor);
                    break;
                }
                case CharacteristicValue: {
                    n = readWriteJob.entry.endHandle;
                    break;
                }
            }
        }
        this.timeoutHandler.removeCallbacksAndMessages(null);
        this.handleForTimeout.set(this.modifiedReadWriteHandle(n, readWriteJob.jobType));
        switch (readWriteJob.jobType) {
            case Read: {
                bl = this.executeReadJob(readWriteJob);
                break;
            }
            case SkippedRead: {
                bl = true;
                break;
            }
            case Write: {
                bl = this.executeWriteJob(readWriteJob);
                break;
            }
            case Mtu: {
                bl = this.executeMtuExchange();
                break;
            }
            case Rssi: {
                bl = this.executeRemoteRssiRead();
            }
        }
        if (bl) {
            this.handleForTimeout.set(this.HANDLE_FOR_RESET);
        } else {
            this.pendingJob = readWriteJob;
            this.timeoutHandler.postDelayed((Runnable)new TimeoutRunnable(this.modifiedReadWriteHandle(n, readWriteJob.jobType)), 3000L);
        }
        if (readWriteJob.jobType != IoJobType.Mtu && readWriteJob.jobType != IoJobType.Rssi) {
            Log.d((String)TAG, (String)("Performing queued job, handle: " + n + " " + (Object)((Object)readWriteJob.jobType) + " (" + (readWriteJob.requestedWriteType == 1) + ") ValueKnown: " + readWriteJob.entry.valueKnown + " Skipping: " + bl + " " + (Object)((Object)readWriteJob.entry.type)));
        }
        GattEntry gattEntry = readWriteJob.entry;
        if (bl) {
            if (n > this.HANDLE_FOR_RESET) {
                boolean bl2;
                boolean bl3 = bl2 = !gattEntry.valueKnown;
                if (bl2) {
                    gattEntry.valueKnown = true;
                    switch (gattEntry.type) {
                        case Characteristic: {
                            Log.d((String)TAG, (String)(readWriteJob.jobType == IoJobType.Read ? "Non-readable" : "Skipped reading of characteristic " + gattEntry.characteristic.getUuid() + " for service " + gattEntry.characteristic.getService().getUuid()));
                            this.leCharacteristicRead(this.qtObject, gattEntry.characteristic.getService().getUuid().toString(), n + 1, gattEntry.characteristic.getUuid().toString(), gattEntry.characteristic.getProperties(), null);
                            break;
                        }
                        case Descriptor: {
                            Log.d((String)TAG, (String)(readWriteJob.jobType == IoJobType.Read ? "Non-readable" : "Skipped reading of descriptor " + gattEntry.descriptor.getUuid() + " for service/char " + gattEntry.descriptor.getCharacteristic().getService().getUuid() + "/" + gattEntry.descriptor.getCharacteristic().getUuid()));
                            this.leDescriptorRead(this.qtObject, gattEntry.descriptor.getCharacteristic().getService().getUuid().toString(), gattEntry.descriptor.getCharacteristic().getUuid().toString(), n + 1, gattEntry.descriptor.getUuid().toString(), null);
                            break;
                        }
                        case CharacteristicValue: {
                            break;
                        }
                        case Service: {
                            Log.w((String)TAG, (String)"Scheduling of Service Gatt entry for service discovery should never happen.");
                        }
                    }
                    try {
                        GattEntry gattEntry2 = this.entries.get(gattEntry.associatedServiceHandle);
                        if (gattEntry2.endHandle == n) {
                            this.finishCurrentServiceDiscovery(gattEntry.associatedServiceHandle);
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        Log.w((String)TAG, (String)("performNextIO(): Unknown service for entry, index: " + gattEntry.associatedServiceHandle + " size: " + this.entries.size()));
                    }
                } else {
                    int n2 = 0;
                    n2 = readWriteJob.jobType == IoJobType.Read ? (gattEntry.type == GattEntryType.Characteristic ? 5 : 6) : (gattEntry.type == GattEntryType.Characteristic ? 2 : 3);
                    this.leServiceError(this.qtObject, n + 1, n2);
                }
            }
            this.performNextIO();
        }
    }

    private BluetoothGattCharacteristic cloneChararacteristic(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        try {
            return this.mCharacteristicConstructor.newInstance(bluetoothGattCharacteristic.getService(), bluetoothGattCharacteristic.getUuid(), bluetoothGattCharacteristic.getInstanceId(), bluetoothGattCharacteristic.getProperties(), bluetoothGattCharacteristic.getPermissions());
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)("Cloning characteristic failed!" + exception));
            return null;
        }
    }

    private boolean executeCharacteristicWriteJob(ReadWriteJob readWriteJob) {
        if (this.mHandler != null || this.mCharacteristicConstructor == null) {
            if (readWriteJob.entry.characteristic.getWriteType() != readWriteJob.requestedWriteType) {
                readWriteJob.entry.characteristic.setWriteType(readWriteJob.requestedWriteType);
            }
            return !readWriteJob.entry.characteristic.setValue(readWriteJob.newValue) || !this.mBluetoothGatt.writeCharacteristic(readWriteJob.entry.characteristic);
        }
        BluetoothGattCharacteristic bluetoothGattCharacteristic = readWriteJob.entry.characteristic;
        BluetoothGattCharacteristic bluetoothGattCharacteristic2 = this.cloneChararacteristic(bluetoothGattCharacteristic);
        if (bluetoothGattCharacteristic2 == null) {
            return true;
        }
        bluetoothGattCharacteristic2.setWriteType(readWriteJob.requestedWriteType);
        return !bluetoothGattCharacteristic2.setValue(readWriteJob.newValue) || !this.mBluetoothGatt.writeCharacteristic(bluetoothGattCharacteristic2);
    }

    private boolean executeDescriptorWriteJob(ReadWriteJob readWriteJob) {
        return !readWriteJob.entry.descriptor.setValue(readWriteJob.newValue) || !this.mBluetoothGatt.writeDescriptor(readWriteJob.entry.descriptor);
    }

    private boolean executeWriteJob(ReadWriteJob readWriteJob) {
        switch (readWriteJob.entry.type) {
            case Characteristic: {
                if (Build.VERSION.SDK_INT >= 33) {
                    int n = this.mBluetoothGatt.writeCharacteristic(readWriteJob.entry.characteristic, readWriteJob.newValue, readWriteJob.requestedWriteType);
                    return n != 0;
                }
                return this.executeCharacteristicWriteJob(readWriteJob);
            }
            case Descriptor: {
                int n;
                if (readWriteJob.entry.descriptor.getUuid().compareTo(this.clientCharacteristicUuid) == 0) {
                    boolean bl;
                    n = 0;
                    int n2 = readWriteJob.newValue[0] & 0xFF;
                    if ((n2 & 1) == 1 || (n2 >> 1 & 1) == 1) {
                        n = 1;
                    }
                    if (!(bl = this.mBluetoothGatt.setCharacteristicNotification(readWriteJob.entry.descriptor.getCharacteristic(), n != 0))) {
                        Log.w((String)TAG, (String)"Cannot set characteristic notification");
                    }
                    Log.d((String)TAG, (String)("Enable notifications: " + (n != 0)));
                }
                if (Build.VERSION.SDK_INT >= 33) {
                    n = this.mBluetoothGatt.writeDescriptor(readWriteJob.entry.descriptor, readWriteJob.newValue);
                    return n != 0;
                }
                return this.executeDescriptorWriteJob(readWriteJob);
            }
            case CharacteristicValue: 
            case Service: {
                return true;
            }
        }
        return false;
    }

    private boolean executeReadJob(ReadWriteJob readWriteJob) {
        switch (readWriteJob.entry.type) {
            case Characteristic: {
                boolean bl;
                try {
                    bl = this.mBluetoothGatt.readCharacteristic(readWriteJob.entry.characteristic);
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                    bl = false;
                }
                if (bl) break;
                return true;
            }
            case Descriptor: {
                boolean bl;
                try {
                    bl = this.mBluetoothGatt.readDescriptor(readWriteJob.entry.descriptor);
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                    bl = false;
                }
                if (bl) break;
                return true;
            }
            case Service: {
                return true;
            }
            case CharacteristicValue: {
                return true;
            }
        }
        return false;
    }

    private int modifiedReadWriteHandle(int n, IoJobType ioJobType) {
        int n2 = n;
        if (n > 65535) {
            Log.w((String)TAG, (String)"Invalid handle");
        }
        n2 &= 0xFFFF;
        switch (ioJobType) {
            case Write: {
                n2 |= 0x10000;
                break;
            }
            case Read: {
                n2 |= 0x20000;
                break;
            }
            case Mtu: {
                n2 = this.HANDLE_FOR_MTU_EXCHANGE;
                break;
            }
            case Rssi: {
                n2 = this.HANDLE_FOR_RSSI_READ;
            }
        }
        return n2;
    }

    synchronized boolean requestConnectionUpdatePriority(double d) {
        if (this.mBluetoothGatt == null) {
            return false;
        }
        int n = 0;
        if (d < 30.0) {
            n = 1;
        } else if (d > 100.0) {
            n = 2;
        }
        try {
            return this.mBluetoothGatt.requestConnectionPriority(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w((String)TAG, (String)("Connection update priority out of range: " + n));
            return false;
        }
    }

    native void leConnectionStateChange(long var1, int var3, int var4);

    native void leMtuChanged(long var1, int var3);

    native void leRemoteRssiRead(long var1, int var3, boolean var4);

    native void leServicesDiscovered(long var1, int var3, String var4);

    native void leServiceDetailDiscoveryFinished(long var1, String var3, int var4, int var5);

    native void leCharacteristicRead(long var1, String var3, int var4, String var5, int var6, byte[] var7);

    native void leDescriptorRead(long var1, String var3, String var4, int var5, String var6, byte[] var7);

    native void leCharacteristicWritten(long var1, int var3, byte[] var4, int var5);

    native void leDescriptorWritten(long var1, int var3, byte[] var4, int var5);

    native void leCharacteristicChanged(long var1, int var3, byte[] var4);

    native void leServiceError(long var1, int var3, int var4);

    private class ReadWriteJob {
        GattEntry entry;
        byte[] newValue;
        int requestedWriteType;
        IoJobType jobType;

        private ReadWriteJob() {
        }
    }

    private static enum IoJobType {
        Read,
        Write,
        Mtu,
        SkippedRead,
        Rssi;

    }

    private class BondStateBroadcastReceiver
    extends BroadcastReceiver {
        private BondStateBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            QtBluetoothLE.this.handleOnReceive(context, intent);
        }
    }

    private class GattEntry {
        GattEntryType type;
        boolean valueKnown = false;
        BluetoothGattService service = null;
        BluetoothGattCharacteristic characteristic = null;
        BluetoothGattDescriptor descriptor = null;
        int endHandle = -1;
        int associatedServiceHandle;

        private GattEntry() {
        }
    }

    private static enum GattEntryType {
        Service,
        Characteristic,
        CharacteristicValue,
        Descriptor;

    }

    private class TimeoutRunnable
    implements Runnable {
        private int pendingJobHandle = -1;

        TimeoutRunnable(int n) {
            this.pendingJobHandle = n;
        }

        @Override
        public void run() {
            boolean bl = QtBluetoothLE.this.handleForTimeout.compareAndSet(this.pendingJobHandle, QtBluetoothLE.this.HANDLE_FOR_RESET);
            if (bl) {
                Log.w((String)QtBluetoothLE.TAG, (String)("****** Timeout for request on handle " + (this.pendingJobHandle & 0xFFFF)));
                Log.w((String)QtBluetoothLE.TAG, (String)"****** Looks like the peripheral does NOT act in accordance to Bluetooth 4.x spec.");
                Log.w((String)QtBluetoothLE.TAG, (String)"****** Please check server implementation. Continuing under reservation.");
                if (this.pendingJobHandle > QtBluetoothLE.this.HANDLE_FOR_RESET) {
                    QtBluetoothLE.this.interruptCurrentIO(this.pendingJobHandle & 0xFFFF);
                } else if (this.pendingJobHandle < QtBluetoothLE.this.HANDLE_FOR_RESET) {
                    QtBluetoothLE.this.interruptCurrentIO(this.pendingJobHandle);
                }
            }
        }
    }
}

