/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.pict;

import com.twelvemonkeys.imageio.plugins.pict.PICTImageReader;
import com.twelvemonkeys.imageio.plugins.pict.PICTProviderInfo;
import com.twelvemonkeys.imageio.spi.ImageReaderSpiBase;
import com.twelvemonkeys.imageio.spi.ReaderWriterProviderInfo;
import java.io.EOFException;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public final class PICTImageReaderSpi
extends ImageReaderSpiBase {
    public PICTImageReaderSpi() {
        super((ReaderWriterProviderInfo)new PICTProviderInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDecodeInput(Object object) throws IOException {
        if (!(object instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream imageInputStream = (ImageInputStream)object;
        if (PICTImageReaderSpi.isOtherFormat(imageInputStream)) {
            return false;
        }
        imageInputStream.mark();
        try {
            if (this.isPICT(imageInputStream)) {
                boolean bl = true;
                return bl;
            }
            imageInputStream.reset();
            imageInputStream.mark();
            PICTImageReaderSpi.skipNullHeader(imageInputStream);
            boolean bl = this.isPICT(imageInputStream);
            return bl;
        }
        catch (EOFException eOFException) {
            boolean bl = false;
            return bl;
        }
        finally {
            imageInputStream.reset();
        }
    }

    static boolean isOtherFormat(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.mark();
        try {
            byte[] byArray = new byte[8];
            imageInputStream.readFully(byArray);
            if (byArray[0] == 66 && byArray[1] == 77) {
                boolean bl = true;
                return bl;
            }
            if (byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 56 && (byArray[4] == 55 || byArray[4] == 57) && byArray[5] == 97) {
                boolean bl = true;
                return bl;
            }
            if (byArray[0] == -1 && byArray[1] == -40 && byArray[2] == -1) {
                boolean bl = true;
                return bl;
            }
            if (byArray[0] == -119 && byArray[1] == 80 && byArray[2] == 78 && byArray[3] == 71 && byArray[4] == 13 && byArray[5] == 10 && byArray[6] == 26 && byArray[7] == 10) {
                boolean bl = true;
                return bl;
            }
            if (byArray[0] == 56 && byArray[1] == 66 && byArray[2] == 80 && byArray[3] == 83) {
                boolean bl = true;
                return bl;
            }
            if (byArray[0] == 73 && byArray[1] == 73 && (byArray[2] == 42 || byArray[2] == 43) && byArray[3] == 0 || byArray[0] == 77 && byArray[1] == 77 && byArray[2] == 0 && (byArray[3] == 42 || byArray[3] == 43)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (EOFException eOFException) {
        }
        finally {
            imageInputStream.reset();
        }
        return false;
    }

    static void skipNullHeader(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.skipBytes(512);
    }

    private boolean isPICT(ImageInputStream imageInputStream) throws IOException {
        imageInputStream.readUnsignedShort();
        int n = imageInputStream.readUnsignedShort();
        int n2 = imageInputStream.readUnsignedShort();
        int n3 = imageInputStream.readUnsignedShort();
        int n4 = imageInputStream.readUnsignedShort();
        if (n4 - n2 < 0 || n3 - n < 0) {
            return false;
        }
        int n5 = imageInputStream.readInt();
        return (n5 & 0xFFFF0000) == 0x11010000 || n5 == 1114879;
    }

    public ImageReader createReaderInstance(Object object) {
        return new PICTImageReader((ImageReaderSpi)((Object)this));
    }

    public String getDescription(Locale locale) {
        return "Apple MacPaint/QuickDraw Picture (PICT) image reader";
    }
}

