/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.bluetooth;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;

class QtBluetoothUtility {
    private static final String TAG = "QtBluetoothUtility";
    private static boolean isScanRequiresLocationChecked = false;
    private static boolean scanRequiresLocation = true;

    QtBluetoothUtility() {
    }

    public static synchronized boolean bluetoothScanRequiresLocation(Context context) {
        Log.d((String)TAG, (String)"Checking if Location is required for bluetooth scan");
        if (isScanRequiresLocationChecked) {
            Log.d((String)TAG, (String)("Using cached result for scan needing location: " + scanRequiresLocation));
            return scanRequiresLocation;
        }
        if (Build.VERSION.SDK_INT < 31) {
            Log.d((String)TAG, (String)"SDK version is below 31, assuming Location needed");
            scanRequiresLocation = true;
            isScanRequiresLocationChecked = true;
            return scanRequiresLocation;
        }
        if (context == null) {
            Log.w((String)TAG, (String)"No context object provided");
            return false;
        }
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 4096);
            String[] stringArray = packageInfo.requestedPermissions;
            int[] nArray = packageInfo.requestedPermissionsFlags;
            if (stringArray != null && nArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!"android.permission.BLUETOOTH_SCAN".equals(stringArray[i])) continue;
                    if ((nArray[i] & 0x10000) != 0) {
                        Log.d((String)TAG, (String)"BLUETOOTH_SCAN with 'neverForLocation' found");
                        scanRequiresLocation = false;
                    } else {
                        Log.d((String)TAG, (String)"BLUETOOTH_SCAN without 'neverForLocation' found");
                        scanRequiresLocation = true;
                    }
                    isScanRequiresLocationChecked = true;
                    return scanRequiresLocation;
                }
            }
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)("An error occurred while checking Bluetooth's location need: " + exception));
            scanRequiresLocation = false;
        }
        Log.d((String)TAG, (String)"BLUETOOTH_SCAN permission not found");
        isScanRequiresLocationChecked = true;
        return scanRequiresLocation;
    }
}

