/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.content.Context;
import android.graphics.Point;
import android.util.Log;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.PopupWindow;
import org.qtproject.qt.android.EditContextView;
import org.qtproject.qt.android.QtEditText;
import org.qtproject.qt.android.QtLayout;
import org.qtproject.qt.android.QtNativeInputConnection;

class EditPopupMenu
implements ViewTreeObserver.OnPreDrawListener,
View.OnLayoutChangeListener,
EditContextView.OnClickListener {
    private final EditContextView m_view;
    private final QtEditText m_editText;
    private PopupWindow m_popup = null;
    private final Activity m_activity;
    private int m_posX;
    private int m_posY;
    private int m_buttons;

    EditPopupMenu(QtEditText qtEditText) {
        this.m_activity = (Activity)qtEditText.getContext();
        this.m_view = new EditContextView((Context)this.m_activity, this);
        this.m_view.addOnLayoutChangeListener(this);
        this.m_editText = qtEditText;
        this.m_editText.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
    }

    private void initOverlay() {
        if (this.m_popup != null) {
            return;
        }
        this.m_popup = new PopupWindow((Context)this.m_activity, null, 16843464);
        this.m_popup.setSplitTouchEnabled(true);
        this.m_popup.setClippingEnabled(false);
        this.m_popup.setContentView((View)this.m_view);
        this.m_popup.setWidth(-2);
        this.m_popup.setHeight(-2);
    }

    void setPosition(int n, int n2, int n3) {
        this.initOverlay();
        this.m_view.updateButtons(n3);
        Point point = this.m_view.getCalculatedSize();
        int[] nArray = new int[2];
        View view = (View)this.m_editText.getParent();
        if (view == null) {
            view = this.m_editText;
        }
        view.getLocationOnScreen(nArray);
        int[] nArray2 = new int[2];
        int[] nArray3 = new int[2];
        this.m_activity.getWindow().getDecorView().getLocationOnScreen(nArray2);
        this.m_activity.getWindow().getDecorView().getLocationInWindow(nArray3);
        int n4 = n + nArray[0] - nArray2[0];
        int n5 = n2 + nArray[1] + (nArray3[1] - nArray2[1]);
        n4 -= point.x / 2;
        if ((n5 -= point.y) < 0) {
            n5 = this.m_editText.getSelectionHandleBottom();
        }
        if (n5 <= 0) {
            try {
                QtLayout qtLayout = (QtLayout)this.m_editText.getParent();
                qtLayout.requestLayout();
            }
            catch (ClassCastException classCastException) {
                Log.w((String)"Qt JAVA", (String)("QtEditText " + (Object)((Object)this.m_editText) + " parent is not a QtLayout, requestLayout() skipped"));
            }
            catch (NullPointerException nullPointerException) {
                Log.w((String)"Qt JAVA", (String)("QtEditText " + (Object)((Object)this.m_editText) + " does not have a parent, requestLayout() skipped"));
            }
        }
        if (view.getWidth() < n + point.x / 2) {
            n4 = view.getWidth() - point.x;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        if (this.m_popup.isShowing()) {
            this.m_popup.update(n4, n5, -1, -1);
        } else {
            this.m_popup.showAtLocation(view, 0, n4, n5);
        }
        this.m_posX = n;
        this.m_posY = n2;
        this.m_buttons = n3;
    }

    void hide() {
        if (this.m_popup != null) {
            this.m_popup.dismiss();
            this.m_popup = null;
        }
    }

    public boolean onPreDraw() {
        if (this.m_popup != null && this.m_popup.isShowing()) {
            this.setPosition(this.m_posX, this.m_posY, this.m_buttons);
        }
        return true;
    }

    public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if ((n3 - n != n7 - n5 || n4 - n2 != n8 - n6) && this.m_popup != null && this.m_popup.isShowing()) {
            this.setPosition(this.m_posX, this.m_posY, this.m_buttons);
        }
    }

    @Override
    public void contextButtonClicked(int n) {
        switch (n) {
            case 17039363: {
                QtNativeInputConnection.cut();
                break;
            }
            case 0x1040001: {
                QtNativeInputConnection.copy();
                break;
            }
            case 17039371: {
                QtNativeInputConnection.paste();
                break;
            }
            case 17039373: {
                QtNativeInputConnection.selectAll();
            }
        }
        this.hide();
    }
}

