/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.metadata.AbstractMetadataMethod;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.DbMetadataMediator;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class GetFunctions
extends AbstractMetadataMethod {
    private static final RowDescriptor ROW_DESCRIPTOR = new RowDescriptorBuilder(11, DbMetadataMediator.datatypeCoder).at(0).simple(449, 63, "FUNCTION_CAT", "FUNCTIONS").addField().at(1).simple(449, 63, "FUNCTION_SCHEM", "FUNCTIONS").addField().at(2).simple(448, 63, "FUNCTION_NAME", "FUNCTIONS").addField().at(3).simple(449, Integer.MAX_VALUE, "REMARKS", "FUNCTIONS").addField().at(4).simple(500, 0, "FUNCTION_TYPE", "FUNCTIONS").addField().at(5).simple(448, 63, "SPECIFIC_NAME", "FUNCTIONS").addField().at(6).simple(449, Integer.MAX_VALUE, "JB_FUNCTION_SOURCE", "FUNCTIONS").addField().at(7).simple(448, 4, "JB_FUNCTION_KIND", "FUNCTIONS").addField().at(8).simple(449, 255, "JB_MODULE_NAME", "FUNCTIONS").addField().at(9).simple(449, 255, "JB_ENTRYPOINT", "FUNCTIONS").addField().at(10).simple(449, 255, "JB_ENGINE_NAME", "FUNCTIONS").addField().toRowDescriptor();

    private GetFunctions(DbMetadataMediator mediator) {
        super(ROW_DESCRIPTOR, mediator);
    }

    public final ResultSet getFunctions(String functionNamePattern) throws SQLException {
        if ("".equals(functionNamePattern)) {
            return this.createEmpty();
        }
        DbMetadataMediator.MetadataQuery metadataQuery = this.createGetFunctionsQuery(functionNamePattern);
        return this.createMetaDataResultSet(metadataQuery);
    }

    @Override
    final RowValue createMetadataRow(ResultSet rs, RowValueBuilder valueBuilder) throws SQLException {
        return valueBuilder.at(0).set(null).at(1).set(null).at(2).setString(rs.getString("FUNCTION_NAME")).at(3).setString(rs.getString("REMARKS")).at(4).setShort(1).at(5).setString(rs.getString("FUNCTION_NAME")).at(6).setString(rs.getString("JB_FUNCTION_SOURCE")).at(7).setString(rs.getString("JB_FUNCTION_KIND")).at(8).setString(rs.getString("JB_MODULE_NAME")).at(9).setString(rs.getString("JB_ENTRYPOINT")).at(10).setString(rs.getString("JB_ENGINE_NAME")).toRowValue(false);
    }

    abstract DbMetadataMediator.MetadataQuery createGetFunctionsQuery(String var1);

    public static GetFunctions create(DbMetadataMediator mediator) {
        FirebirdSupportInfo firebirdSupportInfo = mediator.getFirebirdSupportInfo();
        if (firebirdSupportInfo.isVersionEqualOrAbove(3, 0)) {
            return FB3.createInstance(mediator);
        }
        return FB2_5.createInstance(mediator);
    }

    private static final class FB3
    extends GetFunctions {
        private static final String GET_FUNCTIONS_FRAGMENT_3 = "select\n  trim(trailing from RDB$FUNCTION_NAME) as FUNCTION_NAME,\n  RDB$DESCRIPTION as REMARKS,\n  RDB$FUNCTION_SOURCE as JB_FUNCTION_SOURCE,\n  case\n    when RDB$LEGACY_FLAG = 1 then 'UDF'\n    when RDB$ENGINE_NAME is not null then 'UDR'\n    else 'PSQL'\n  end as JB_FUNCTION_KIND,\n  trim(trailing from RDB$MODULE_NAME) as JB_MODULE_NAME,\n  trim(trailing from RDB$ENTRYPOINT) as JB_ENTRYPOINT,\n  trim(trailing from RDB$ENGINE_NAME) as JB_ENGINE_NAME\nfrom RDB$FUNCTIONS\nwhere RDB$PACKAGE_NAME is null\n";
        private static final String GET_FUNCTIONS_ORDER_BY_3 = "order by RDB$PACKAGE_NAME, RDB$FUNCTION_NAME";

        private FB3(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetFunctions createInstance(DbMetadataMediator mediator) {
            return new FB3(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetFunctionsQuery(String functionNamePattern) {
            Clause functionNameClause = new Clause("RDB$FUNCTION_NAME", functionNamePattern);
            String queryText = GET_FUNCTIONS_FRAGMENT_3 + functionNameClause.getCondition("and ", "\n") + GET_FUNCTIONS_ORDER_BY_3;
            return new DbMetadataMediator.MetadataQuery(queryText, Clause.parameters(functionNameClause));
        }
    }

    private static final class FB2_5
    extends GetFunctions {
        private static final String GET_FUNCTIONS_FRAGMENT_2_5 = "select\n  RDB$FUNCTION_NAME as FUNCTION_NAME,\n  RDB$DESCRIPTION as REMARKS,\n  cast(null as blob sub_type text) as JB_FUNCTION_SOURCE,\n  'UDF' as JB_FUNCTION_KIND,\n  trim(trailing from RDB$MODULE_NAME) as JB_MODULE_NAME,\n  trim(trailing from RDB$ENTRYPOINT) as JB_ENTRYPOINT,\n  cast(null as varchar(255)) as JB_ENGINE_NAME\nfrom RDB$FUNCTIONS\n";
        private static final String GET_FUNCTIONS_ORDER_BY_2_5 = "order by RDB$FUNCTION_NAME";

        private FB2_5(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetFunctions createInstance(DbMetadataMediator mediator) {
            return new FB2_5(mediator);
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetFunctionsQuery(String functionNamePattern) {
            Clause functionNameClause = new Clause("RDB$FUNCTION_NAME", functionNamePattern);
            String queryText = GET_FUNCTIONS_FRAGMENT_2_5 + functionNameClause.getCondition("where ", "\n") + GET_FUNCTIONS_ORDER_BY_2_5;
            return new DbMetadataMediator.MetadataQuery(queryText, Clause.parameters(functionNameClause));
        }
    }
}

