/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.property;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import us.fatehi.utility.property.Property;
import us.fatehi.utility.property.PropertyName;

public abstract class AbstractProperty
implements Property {
    private static final long serialVersionUID = -7150431683440256142L;
    private final PropertyName propertyName;
    private final Serializable value;

    protected AbstractProperty(PropertyName name, Serializable value) {
        this.propertyName = Objects.requireNonNull(name, "No property name provided");
        this.value = value != null && value.getClass().isArray() ? (Serializable)((Object)Arrays.asList((Object[])value)) : value;
    }

    public final boolean equals(Object obj) {
        boolean nameEquals;
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Property)) {
            return false;
        }
        Property other = (Property)obj;
        if (obj instanceof AbstractProperty) {
            AbstractProperty property = (AbstractProperty)obj;
            nameEquals = Objects.equals(this.propertyName, property.propertyName);
        } else {
            nameEquals = Objects.equals(this.propertyName.getName(), other.getName());
        }
        return nameEquals && Objects.equals(this.value, other.getValue());
    }

    @Override
    public final String getName() {
        return this.propertyName.getName();
    }

    @Override
    public final String getDescription() {
        return this.propertyName.getDescription();
    }

    @Override
    public Serializable getValue() {
        return this.value;
    }

    public final int hashCode() {
        return Objects.hash(this.propertyName, this.value);
    }

    public String toString() {
        return this.getName() + " = " + String.valueOf(this.getValue());
    }
}

