/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.wasm;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.array.ArrayBufferViewGetByteLengthNode;
import com.oracle.truffle.js.nodes.array.GetViewByteLengthNode;
import com.oracle.truffle.js.nodes.wasm.ExportByteSourceNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSDataView;
import com.oracle.truffle.js.runtime.builtins.JSDataViewObject;
import com.oracle.truffle.js.runtime.builtins.JSTypedArrayObject;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.graalvm.polyglot.io.ByteSequence;

public abstract class ExportByteSourceNode
extends JavaScriptBaseNode {
    private final JSContext context;
    private final String nonByteSourceMessage;
    private final String emptyByteSourceMessage;
    @Node.Child
    private InteropLibrary interop = (InteropLibrary)InteropLibrary.getFactory().createDispatched(5);

    protected ExportByteSourceNode(JSContext context, String nonByteSourceMessage, String emptyByteSourceMessage) {
        this.context = context;
        this.nonByteSourceMessage = nonByteSourceMessage;
        this.emptyByteSourceMessage = emptyByteSourceMessage;
    }

    public abstract ByteSequence execute(Object var1);

    public static ExportByteSourceNode create(JSContext context, String nonByteSourceMessage, String emptyByteSourceMessage) {
        return ExportByteSourceNodeGen.create(context, nonByteSourceMessage, emptyByteSourceMessage);
    }

    @Specialization
    protected ByteSequence exportBuffer(JSArrayBufferObject arrayBuffer, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
        int length = !this.context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer) ? 0 : arrayBuffer.getByteLength();
        return this.exportBuffer(arrayBuffer, 0, length, errorBranch);
    }

    @Specialization
    protected ByteSequence exportTypedArray(JSTypedArrayObject typedArray, @Cached ArrayBufferViewGetByteLengthNode getByteLengthNode, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
        int offset = JSArrayBufferView.getByteOffset(typedArray, this.context);
        int length = getByteLengthNode.executeInt(this, typedArray, this.context);
        return this.exportBuffer(typedArray.getArrayBuffer(), offset, length, errorBranch);
    }

    @Specialization
    protected ByteSequence exportDataView(JSDataViewObject dataView, @Cached GetViewByteLengthNode getByteLengthNode, @Cached @Cached.Shared InlinedBranchProfile errorBranch) {
        int offset = JSDataView.dataViewGetByteOffset(dataView);
        int length = getByteLengthNode.execute(dataView, this.context);
        return this.exportBuffer(dataView.getArrayBuffer(), offset, length, errorBranch);
    }

    @Fallback
    protected ByteSequence exportOther(Object other) {
        throw Errors.createTypeError(this.nonByteSourceMessage, (Node)this);
    }

    private ByteSequence exportBuffer(JSArrayBufferObject arrayBuffer, int offset, int length, InlinedBranchProfile errorBranch) {
        JSArrayBufferObject buffer = arrayBuffer;
        if (this.emptyByteSourceMessage != null && length == 0) {
            errorBranch.enter((Node)this);
            throw Errors.createCompileError(this.emptyByteSourceMessage, (Node)this);
        }
        JSRealm realm = this.getRealm();
        if (!this.context.getTypedArrayNotDetachedAssumption().isValid() && JSArrayBuffer.isDetachedBuffer(arrayBuffer)) {
            buffer = JSArrayBuffer.createArrayBuffer(this.context, realm, 0);
        }
        byte[] bytes = new byte[length];
        JSInteropUtil.copyFromBuffer(buffer, offset, bytes, 0, length, this.interop);
        ExportByteSourceNode.reportLoopCount((Node)this, length);
        return ByteSequence.create((byte[])bytes);
    }
}

