/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.object.LayoutImpl;
import java.util.List;
import java.util.Objects;
import org.graalvm.nativeimage.hosted.Feature;

class DynamicObjectFeature
implements Feature {
    private static final String LAYOUT_IMPL_CLASS_NAME = "com.oracle.truffle.api.object.LayoutImpl";

    DynamicObjectFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return access.findClassByName(LAYOUT_IMPL_CLASS_NAME) != null;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (Runtime.version().feature() == 21) {
            List<String> markAsReachable = List.of("com.oracle.truffle.object.DefaultLayout", "com.oracle.truffle.object.DefaultLayout$LayoutInfo");
            access.registerReachabilityHandler(acc -> markAsReachable.forEach(className -> acc.registerAsUsed(Objects.requireNonNull(access.findClassByName(className), className))), new Object[]{Objects.requireNonNull(access.findClassByName(LAYOUT_IMPL_CLASS_NAME))});
        }
    }

    public void cleanup() {
        LayoutImpl.resetNativeImageState();
    }

    public String getDescription() {
        return "Provides support for DynamicObject";
    }
}

