/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.core.trace.dsl.impl;

import com.intellij.debugger.streams.core.trace.dsl.CodeBlock;
import com.intellij.debugger.streams.core.trace.dsl.CompositeCodeBlock;
import com.intellij.debugger.streams.core.trace.dsl.Convertable;
import com.intellij.debugger.streams.core.trace.dsl.Expression;
import com.intellij.debugger.streams.core.trace.dsl.ForLoopBody;
import com.intellij.debugger.streams.core.trace.dsl.IfBranch;
import com.intellij.debugger.streams.core.trace.dsl.Statement;
import com.intellij.debugger.streams.core.trace.dsl.StatementFactory;
import com.intellij.debugger.streams.core.trace.dsl.TryBlock;
import com.intellij.debugger.streams.core.trace.dsl.Variable;
import com.intellij.debugger.streams.core.trace.dsl.VariableDeclaration;
import com.intellij.debugger.streams.core.trace.dsl.impl.AssignmentStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\t\n\u0002\u0010 \n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0096\u0002J\u0016\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J9\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00182\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000e0\u001f\u00a2\u0006\u0002\b!H\u0016J!\u0010\"\u001a\u00020#2\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u000e0\u001f\u00a2\u0006\u0002\b!H\u0016J)\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u00182\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u000e0\u001f\u00a2\u0006\u0002\b!H\u0016J1\u0010'\u001a\u00020\u00182\u0006\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020*2\u0012\u0010+\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180,\"\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010-J1\u0010.\u001a\u00020\u000e2\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u00182\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000e0\u001f\u00a2\u0006\u0002\b!H\u0016J!\u00101\u001a\u00020\u000e2\u0017\u0010\u0017\u001a\u0013\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u000e0\u001f\u00a2\u0006\u0002\b!H\u0016J\u0015\u00102\u001a\u00020\u000e*\u00020\u00132\u0006\u00103\u001a\u00020\u0018H\u0096\u0004J\u0010\u00104\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0016J\u000e\u00105\u001a\b\u0012\u0004\u0012\u00020\b06H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u00067"}, d2={"Lcom/intellij/debugger/streams/core/trace/dsl/impl/CodeBlockBase;", "Lcom/intellij/debugger/streams/core/trace/dsl/CompositeCodeBlock;", "myFactory", "Lcom/intellij/debugger/streams/core/trace/dsl/StatementFactory;", "<init>", "(Lcom/intellij/debugger/streams/core/trace/dsl/StatementFactory;)V", "myStatements", "", "Lcom/intellij/debugger/streams/core/trace/dsl/Convertable;", "size", "", "getSize", "()I", "unaryPlus", "", "Lcom/intellij/debugger/streams/core/trace/dsl/Statement;", "statement", "Lkotlin/Function0;", "declare", "Lcom/intellij/debugger/streams/core/trace/dsl/Variable;", "variable", "isMutable", "", "init", "Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "declaration", "Lcom/intellij/debugger/streams/core/trace/dsl/VariableDeclaration;", "forLoop", "initialization", "condition", "afterThought", "Lkotlin/Function1;", "Lcom/intellij/debugger/streams/core/trace/dsl/ForLoopBody;", "Lkotlin/ExtensionFunctionType;", "tryBlock", "Lcom/intellij/debugger/streams/core/trace/dsl/TryBlock;", "Lcom/intellij/debugger/streams/core/trace/dsl/CodeBlock;", "ifBranch", "Lcom/intellij/debugger/streams/core/trace/dsl/IfBranch;", "call", "receiver", "methodName", "", "args", "", "(Lcom/intellij/debugger/streams/core/trace/dsl/Expression;Ljava/lang/String;[Lcom/intellij/debugger/streams/core/trace/dsl/Expression;)Lcom/intellij/debugger/streams/core/trace/dsl/Expression;", "forEachLoop", "iterateVariable", "collection", "scope", "assign", "expression", "addStatement", "getStatements", "", "intellij.debugger.streams.core"})
public abstract class CodeBlockBase
implements CompositeCodeBlock {
    @NotNull
    private final StatementFactory myFactory;
    @NotNull
    private final List<Convertable> myStatements;

    public CodeBlockBase(@NotNull StatementFactory myFactory) {
        Intrinsics.checkNotNullParameter((Object)myFactory, (String)"myFactory");
        this.myFactory = myFactory;
        this.myStatements = new ArrayList();
    }

    @Override
    public int getSize() {
        return this.myStatements.size();
    }

    @Override
    public void unaryPlus(@NotNull Statement $this$unaryPlus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
        this.myStatements.add($this$unaryPlus);
    }

    @Override
    public void statement(@NotNull Function0<? extends Statement> statement) {
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        this.myStatements.add((Convertable)statement.invoke());
    }

    @Override
    @NotNull
    public Variable declare(@NotNull Variable variable, boolean isMutable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.declare(this.myFactory.createVariableDeclaration(variable, isMutable));
    }

    @Override
    @NotNull
    public Variable declare(@NotNull Variable variable, @NotNull Expression init, boolean isMutable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)init, (String)"init");
        return this.declare(this.myFactory.createVariableDeclaration(variable, init, isMutable));
    }

    @Override
    @NotNull
    public Variable declare(@NotNull VariableDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.addStatement(declaration);
        return declaration.getVariable();
    }

    @Override
    public void forLoop(@NotNull VariableDeclaration initialization, @NotNull Expression condition, @NotNull Expression afterThought, @NotNull Function1<? super ForLoopBody, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)initialization, (String)"initialization");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)afterThought, (String)"afterThought");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        ForLoopBody loopBody = this.myFactory.createEmptyForLoopBody(initialization.getVariable());
        init.invoke((Object)loopBody);
        this.addStatement(this.myFactory.createForLoop(initialization, condition, afterThought, loopBody));
    }

    @Override
    @NotNull
    public TryBlock tryBlock(@NotNull Function1<? super CodeBlock, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        CodeBlock codeBlock = this.myFactory.createEmptyCodeBlock();
        init.invoke((Object)codeBlock);
        TryBlock tryBlock = this.myFactory.createTryBlock(codeBlock);
        this.myStatements.add(tryBlock);
        return tryBlock;
    }

    @Override
    @NotNull
    public IfBranch ifBranch(@NotNull Expression condition, @NotNull Function1<? super CodeBlock, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        CodeBlock ifBody = this.myFactory.createEmptyCodeBlock();
        init.invoke((Object)ifBody);
        IfBranch branch = this.myFactory.createIfBranch(condition, ifBody);
        this.addStatement(branch);
        return branch;
    }

    @Override
    @NotNull
    public Expression call(@NotNull Expression receiver, @NotNull String methodName, Expression ... args) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Expression call = receiver.call(methodName, Arrays.copyOf(args, args.length));
        this.addStatement(call);
        return call;
    }

    @Override
    public void forEachLoop(@NotNull Variable iterateVariable, @NotNull Expression collection, @NotNull Function1<? super ForLoopBody, Unit> init) {
        Intrinsics.checkNotNullParameter((Object)iterateVariable, (String)"iterateVariable");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter(init, (String)"init");
        ForLoopBody loopBody = this.myFactory.createEmptyForLoopBody(iterateVariable);
        init.invoke((Object)loopBody);
        this.addStatement(this.myFactory.createForEachLoop(iterateVariable, collection, loopBody));
    }

    @Override
    public void scope(@NotNull Function1<? super CodeBlock, Unit> init) {
        Intrinsics.checkNotNullParameter(init, (String)"init");
        CodeBlock codeBlock = this.myFactory.createEmptyCodeBlock();
        init.invoke((Object)codeBlock);
        this.addStatement(this.myFactory.createScope(codeBlock));
    }

    @Override
    public void assign(@NotNull Variable $this$assign, @NotNull Expression expression) {
        Intrinsics.checkNotNullParameter((Object)$this$assign, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        AssignmentStatement assignmentStatement = this.myFactory.createAssignmentStatement($this$assign, expression);
        this.addStatement(assignmentStatement);
    }

    @Override
    public void addStatement(@NotNull Convertable statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        ((Collection)this.myStatements).add(statement);
    }

    @Override
    @NotNull
    public List<Convertable> getStatements() {
        return new ArrayList(this.myStatements);
    }
}

